/**
 * 
 */
package org.gcube.portlets.admin.gcubereleases.client;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.gcube.portlets.admin.gcubereleases.client.event.DisplaySelectedReleaseEvent;
import org.gcube.portlets.admin.gcubereleases.client.event.DisplaySelectedReleaseEventHandler;
import org.gcube.portlets.admin.gcubereleases.client.event.ManagePackagesEvent;
import org.gcube.portlets.admin.gcubereleases.client.event.ManagePackagesEventHandler;
import org.gcube.portlets.admin.gcubereleases.client.event.ManageReleasesEvent;
import org.gcube.portlets.admin.gcubereleases.client.event.ManageReleasesEventHandler;
import org.gcube.portlets.admin.gcubereleases.client.event.NewInsertReleaseEventHandler;
import org.gcube.portlets.admin.gcubereleases.client.event.NewInsertReleasesEvent;
import org.gcube.portlets.admin.gcubereleases.client.event.ReloadReleasesEvent;
import org.gcube.portlets.admin.gcubereleases.client.event.ReloadReleasesEventHandler;
import org.gcube.portlets.admin.gcubereleases.client.manage.NewReleaseManager;
import org.gcube.portlets.admin.gcubereleases.client.manage.PackagesManager;
import org.gcube.portlets.admin.gcubereleases.client.manage.ReleasesManager;
import org.gcube.portlets.admin.gcubereleases.client.rpc.GcubeReleasesServiceAsync;
import org.gcube.portlets.admin.gcubereleases.client.view.DividerElement;
import org.gcube.portlets.admin.gcubereleases.shared.Release;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootPanel;


/**
 * The Class GcubeReleasesAppRootPanel.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 19, 2015
 */
public class GcubeReleasesAppRootPanel {
	
	/** The Constant DIV_BUILDREPORTMANAGER. */
	private static final String DIV_BUILDREPORTMANAGER = "buildreportmanager";
	
	/** The Constant HEADER_ID. */
	public static final String HEADER_ID = "release-title";
	
	/** The Constant JAVADOC_RESOLVER_SERVLET. */
	public static final String JAVADOC_RESOLVER_SERVLET = com.google.gwt.core.client.GWT.getModuleBaseURL() + "javadocResolver";
	
	/** The header pg mng. */
	private HeaderPageMng headerPgMng = new HeaderPageMng(this);
	
	/** The root panel. */
	private FlowPanel rootPanel = new FlowPanel();
	
	/** The body page mng. */
	private BodyPageMng bodyPageMng = new BodyPageMng(this);
	
	/** The release displayed. */
	private Release releaseDisplayed;
	
	/** The all releases. */
	private List<Release> allReleases;
	
	/** The subsystem i ds. */
	private Set<String> subsystemIDs;
	
	/** The Constant eventBus. */
	public final static HandlerManager eventBus = new HandlerManager(null);
	
	/**
	 * Instantiates a new gcube releases app root panel.
	 */
	public GcubeReleasesAppRootPanel() {
		rootPanel.add(headerPgMng.getHeader());
		rootPanel.add(new DividerElement());
		rootPanel.add(bodyPageMng.getBody());
		RootPanel.get(DIV_BUILDREPORTMANAGER).add(rootPanel);
		
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				loadReleases(true);
			}
		});
		
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				isDisplayManagementMode();
			}
		});
		
		eventBus.addHandler(NewInsertReleasesEvent.TYPE, new NewInsertReleaseEventHandler() {
			
			@Override
			public void onNewInsertRelease(NewInsertReleasesEvent manageReleasesEvent) {
				NewReleaseManager mng = new NewReleaseManager();
				mng.showDialog();
			}
		});
		
		eventBus.addHandler(ManageReleasesEvent.TYPE, new ManageReleasesEventHandler() {
			
			@Override
			public void onManageReleases(ManageReleasesEvent manageReleasesEvent) {
				ReleasesManager releasesManager = new ReleasesManager(releaseDisplayed);
				releasesManager.showDialog();
			}
		});
		
		eventBus.addHandler(ManagePackagesEvent.TYPE, new ManagePackagesEventHandler() {
			
			@Override
			public void onManagePackages(ManagePackagesEvent managePackagesEvent) {
				final PackagesManager pck = new PackagesManager(releaseDisplayed, subsystemIDs);
				pck.showDialog();
			}
		});
		
		eventBus.addHandler(ReloadReleasesEvent.TYPE, new ReloadReleasesEventHandler() {
		
			@Override
			public void onReleadReleases(ReloadReleasesEvent reloadReleasesEvent) {
				GWT.log("Fired reloadReleasesEvent");
				loadReleases(reloadReleasesEvent.isDisplayFirst());
				
			}
		});
		
		eventBus.addHandler(DisplaySelectedReleaseEvent.TYPE, new DisplaySelectedReleaseEventHandler() {
			
			@Override
			public void onSelectRelease(DisplaySelectedReleaseEvent loadSelecteReleaseEvent) {
				if(loadSelecteReleaseEvent.getRelease()!=null){
					GWT.log("Fired DisplaySelectedReleaseEvent");
					setReleaseDisplayed(loadSelecteReleaseEvent.getRelease());
					displayRelease(loadSelecteReleaseEvent.getRelease());
				}
			}
		});
	}
	
	private void isDisplayManagementMode() {
		GcubeReleasesServiceAsync.Util.getInstance().isManagementMode(new AsyncCallback<Boolean>() {

			@Override
			public void onFailure(Throwable caught) {
				headerPgMng.showLoading(false);
				
			}

			@Override
			public void onSuccess(Boolean result) {
				headerPgMng.showLoading(result);
				
			}
		});
		
	}
	
	/**
	 * Load releases.
	 *
	 * @param displayFirst the display first
	 */
	private void loadReleases(final boolean displayFirst){
		
		GcubeReleasesServiceAsync.Util.getInstance().getReleases(true, new AsyncCallback<List<Release>>() {
			
			@Override
			public void onSuccess(List<Release> result) {
				if(result!=null && result.size()>0){
					allReleases = result;

					if(displayFirst){
						setReleaseDisplayed(result.get(0));
						displayRelease(result.get(0));
					}else
						updateOtherReleases();
					
				}else
					bodyPageMng.showError("Sorry, an error occurred when reading DB releases!! Try again later");
			}
			
			@Override
			public void onFailure(Throwable caught) {
				GWT.log("Error on getReleases");
				
			}
		});
	}

	
	/**
	 * Update other releases.
	 */
	private void updateOtherReleases() {
		headerPgMng.setOtherReleases(allReleases, releaseDisplayed);
	}
	
	/**
	 * Sets the release displayed.
	 *
	 * @param release the new release displayed
	 */
	private void setReleaseDisplayed(Release release){
		releaseDisplayed = release;
	}
	
	/**
	 * Display release.
	 *
	 * @param release the release
	 */
	public void displayRelease(final Release release){
		
		headerReset();
		bodyReset();
		headerPgMng.showLoading(true);
		GcubeReleasesServiceAsync.Util.getInstance().getReleaseByID(release.getId(), new AsyncCallback<Release>() {

			@Override
			public void onFailure(Throwable caught) {
//				setReleaseDisplayed(null);
				headerPgMng.showLoading(false);
				GWT.log("Error on getReleaseByID", caught);
			}

			@Override
			public void onSuccess(Release result) {
				
				headerPgMng.showLoading(false);
				if(result!=null){
					setReleaseDisplayed(result);
					updateOtherReleases();
					headerPgMng.updateHeaderTitleAndInfo(result);
					loadSubsystemsForReleaseID(release.getId());
				}
			}
		});
	}
	
	/**
	 * Load subsystems for release id.
	 *
	 * @param releaseID the release id
	 */
	public void loadSubsystemsForReleaseID(String releaseID){
		
		bodyPageMng.getBody().setLoading(true, "Loading Subsystems..");
		
		GcubeReleasesServiceAsync.Util.getInstance().getSubsystemsForReleaseID(releaseID, new AsyncCallback<Map<String, Long>>() {

			@Override
			public void onFailure(Throwable caught) {
				GWT.log("Error on getSubsystemsForReleaseID", caught);
				
			}

			@Override
			public void onSuccess(Map<String, Long> result) {
				
				if(result==null){
					Window.alert("An error occurred when loading subsystems, try again later!");
					return;
				}
				
				subsystemIDs = result.keySet();
				
				bodyPageMng.setLoading(false, null);
				if(result!=null && result.size()>0){
					headerPgMng.headerUpdateNavigation("Subsystems ["+result.size()+"]", (LinkedHashMap<String, Long>) result);
					bodyPageMng.updateBodyView(releaseDisplayed, (LinkedHashMap<String, Long>) result);
				}else{
					bodyPageMng.showInfo("No Subsystems found");
				}
			}
		});
	}

	/**
	 * Header reset.
	 */
	public void headerReset() {
		headerPgMng.headerReset();
	}
	
	/**
	 * Body reset.
	 */
	public void bodyReset() {
		bodyPageMng.bodyReset();
	}

	/**
	 * Enable filter by subsystem.
	 *
	 * @param b the b
	 */
	public void enableFilterBySubsystem(boolean b) {
		headerPgMng.enableFilterBySubsystem(b);
	}
	

}
