package org.gcube.portlets.admin.gcubereleases.server.database;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Class EntityManagerFactoryCreator.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 19, 2015
 */
public class EntityManagerFactoryCreator {

	public static final String PERSISTENCE_DB_GCUBE_RELEASES = "PERSISTENCE_DB_GCUBE_RELEASES";
	public static final String GCUBE_RELEASES_DB = "gcube-releases";
	public static Logger logger = LoggerFactory.getLogger(EntityManagerFactoryCreator.class);

	public static EntityManagerFactory factoryGcubeReleases;

	/**
	 * Gets the entity manager factory for builder report db.
	 *
	 * @return the entity manager factory for builder report db
	 */
	public static synchronized EntityManagerFactory getEntityManagerFactoryForBuilderReportDB() {

		if (factoryGcubeReleases == null || !factoryGcubeReleases.isOpen())
			factoryGcubeReleases = createEntityManagerFactory(GCUBE_RELEASES_DB);
		
		return factoryGcubeReleases;

	}

	/**
	 * Creates the entity manager factory.
	 *
	 * @param dbName the db name
	 * @return the entity manager factory
	 */
	private static EntityManagerFactory createEntityManagerFactory(String dbName) {

		Map<String, String> properties = new HashMap<String, String>();
		// properties.put("javax.persistence.jdbc.driver", jdbcDriverH2);
		EntityManagerFactory emf = null;
		try {
//			properties.put(JAVAX_PERSISTENCE_JDBC_URL, getConnectionUrl(dbName));
			emf = Persistence.createEntityManagerFactory(PERSISTENCE_DB_GCUBE_RELEASES, properties);
		} catch (Exception e) {
			logger.error("error on get createEntityManagerFactory " + e, e);
		}
		// emf = Persistence.createEntityManagerFactory("jpablogPUnit");
//		logger.info("created entity manager factory on: "+ properties.get(JAVAX_PERSISTENCE_JDBC_URL));
		return emf;
	}

}
