/**
 * 
 */
package org.gcube.portlets.admin.gcubereleases.server.persistence;

import javax.persistence.EntityManager;
import javax.persistence.PostRemove;

import org.gcube.portlets.admin.gcubereleases.server.database.DaoGcubeBuilderReportDBManager;
import org.gcube.portlets.admin.gcubereleases.shared.Package;
import org.gcube.portlets.admin.gcubereleases.shared.Release;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The listener interface for receiving packageEntity events.
 * The class that is interested in processing a packageEntity
 * event implements this interface, and the object created
 * with that class is registered with a component using the
 * component's <code>addPackageEntityListener<code> method. When
 * the packageEntity event occurs, that object's appropriate
 * method is invoked.
 *
 * @see PackageEntityEvent
 */
public class PackageEntityListener {
	
	protected static Logger logger = LoggerFactory.getLogger(PackageEntityListener.class);
	/*
//	@PrePersist void onPrePersist(Object entity ) {}
	@PostPersist void onPostPersist(org.gcube.portlets.admin.buildreportmng.shared.Package entity) {
		System.out.println("onPostPersist "+entity);
		logger.trace("onPostPersist "+entity);
	}
	
	@PostLoad void onPostLoad(org.gcube.portlets.admin.buildreportmng.shared.Package entity) {
//		System.out.println("onPostLoad "+entity);
//		logger.trace("onPostLoad "+entity);
	}
	
	@PreUpdate void onPreUpdate(org.gcube.portlets.admin.buildreportmng.shared.Package entity) {
		System.out.println("onPreUpdate "+entity);
		logger.trace("onPreUpdate "+entity);
	}
	
	@PostUpdate void onPostUpdate(org.gcube.portlets.admin.buildreportmng.shared.Package entity) {
		System.out.println("onPreRemove "+entity);
		logger.trace("onPreRemove "+entity);
	}
	
	@PreRemove void onPreRemove(org.gcube.portlets.admin.buildreportmng.shared.Package entity) {
		System.out.println("onPreRemove "+entity);
		logger.trace("onPreRemove "+entity);
	}
	*/
	/**
	 * On post remove.
	 *
	 * @param entity the entity
	 */
	@PostRemove void onPostRemove(org.gcube.portlets.admin.gcubereleases.shared.Package entity) {
//		System.out.println("onPostRemove "+entity);
		logger.trace("onPostRemove Package: "+entity.getInternalId());
		decrementPackages(entity);
	}
	
	/**
	 * Decrement packages.
	 *
	 * @param pck the pck
	 */
	private void decrementPackages(Package pck){
		logger.info("Decrementing packages..");
		DaoGcubeBuilderReportDBManager<Release> daoManager = new DaoGcubeBuilderReportDBManager<Release>();
		daoManager.instanceReleaseEntity();
		ReleasePersistence relPersistence = daoManager.getReleasePersistenceEntity();

		Release daoRelease = null;
		EntityManager em = null;
		try {
			em = relPersistence.createNewManager();
			daoRelease = em.find(Release.class, pck.getRelease().getInternalId());
			int newnop = daoRelease.getPackagesNmb()-1;
			daoRelease.setPackagesNmb(newnop);
			em.getTransaction().begin();
			em.merge(daoRelease);
			em.getTransaction().commit();
			logger.info("Updated number of packages at " + newnop + " for "+daoRelease);
		} catch (Exception e) {
			logger.error("Error in decrementPackages for " + daoRelease, e);

		} finally {
			if(em!=null)
				em.close();
		}
	}
}
