/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.gcubereleases;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.admin.gcubereleases.HttpRequestUtil;
import org.gcube.portlets.admin.gcubereleases.server.GcubeReleasesServiceImpl;
import org.gcube.portlets.admin.gcubereleases.shared.Release;

public class Fill_DB {
    public static GcubeReleasesServiceImpl buildReportServiceImpl = new GcubeReleasesServiceImpl();
    public static boolean onLine = true;
    public static Logger logger = Logger.getLogger(Fill_DB.class);
    private static Comparator<String> ALPHABETICAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            if (str1.length() < str2.length()) {
                return -1;
            }
            if (str1.length() > str2.length()) {
                return 1;
            }
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    };

    public static void main(String[] args) {
        try {
            String releaseID = "org.gcube.3-6-0";
            String releaseName = "GCube 3.6.0";
            String url = "http://eticsbuild2.research-infrastructures.eu/BuildReport/bdownload/AllBuilds/org.gcube.3-6-0/BUILD_14/reports/distribution/distribution.xml";
            String description = "description GCube 3.6.0";
            Fill_DB.storeRelease(releaseID, releaseName, description, url, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readFromEtics() {
        try {
            int releaseMax = 3;
            int releaseMin = 1;
            int minorMax = 17;
            int minorMin = 0;
            int revisionMax = 4;
            int revisionMin = 0;
            for (int rl = releaseMin; rl <= releaseMax; ++rl) {
                for (int m = minorMin; m <= minorMax; ++m) {
                    for (int rv = revisionMin; rv <= revisionMax; ++rv) {
                        String releaseID = "org.gcube." + rl + "-" + m + "-" + rv;
                        String url = "http://grids16.eng.it/BuildReport/bdownload/Recent_Builds/" + releaseID + "/latest/reports/distribution/distribution.xml";
                        logger.debug((Object)("Tentative to: " + releaseID));
                        if (HttpRequestUtil.urlExists(url)) {
                            String releaseName = "GCube " + rl + "." + m + "." + rv;
                            String description = "description GCube " + rl + "." + m + "." + rv;
                            continue;
                        }
                        logger.warn((Object)("Skipping release: " + releaseID));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static List<String> listFolders(File folder) {
        ArrayList<String> folders = new ArrayList<String>();
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                folders.add(fileEntry.getName());
                continue;
            }
            System.out.println("is file: " + fileEntry.getName());
        }
        return folders;
    }

    private static void storeRelease(String releaseID, String releaseName, String description, String url, Long releaseDate) {
        Release release = new Release(releaseID, releaseName, url, releaseDate);
        release.setDescription(description);
        release.setOnLine(onLine);
        try {
            buildReportServiceImpl.storeReleaseIntoDB(release);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void storeReleaseFromLocal(String releaseID, String releaseName, String description, String url, Long releaseDate) {
        Release release = new Release(releaseID, releaseName, url, releaseDate);
        release.setDescription(description);
        release.setOnLine(onLine);
        try {
            buildReportServiceImpl.storeLocalReleaseIntoDB(release);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

