/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.views.resourcedetails;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridViewConfig;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.admin.resourcemanagement.client.utils.Commands;
import org.gcube.portlets.admin.resourcemanagement.client.views.resourcedetails.ContextMenuFactory;
import org.gcube.portlets.admin.resourcemanagement.client.views.resourcedetails.ResourceDetailsPanel;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.console.ConsoleMessageBroker;
import org.gcube.portlets.admin.resourcemanagement.client.widgets.registry.WidgetsRegistry;
import org.gcube.resourcemanagement.support.client.utils.StatusHandler;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;
import org.gcube.resourcemanagement.support.shared.operations.SupportedOperations;

public class ResourceDetailsPanel {
    private ContentPanel rootPanel = null;
    private Component widget = null;
    private boolean groupingEnabled = true;
    private String collapsibleColumn = "SubType";
    private ToolBar toolBar = new ToolBar();
    private static final String btnGroupID = "btn-grid-group";
    private static final String btnRefreshID = "btn-grid-refresh";
    private boolean highlightInvalidFields = false;

    public ResourceDetailsPanel() {
        this.widget = new Text();
        this.init();
    }

    private ListStore<ModelData> getStore() {
        return this.getGrid().getStore();
    }

    public final List<ModelData> getElemsForInstall() {
        Vector<ModelData> retval = new Vector<ModelData>();
        for (ModelData r : this.getStore().getModels()) {
            if (!r.getProperties().containsKey("toDeploy") || !Boolean.parseBoolean(r.get("toDeploy").toString())) continue;
            retval.add(r);
        }
        return retval;
    }

    public final void refreshModel() {
        for (ModelData s : this.getSelection()) {
            this.getStore().update(s);
        }
    }

    public final List<ModelData> getSelection() {
        if (this.getGrid() == null || this.getGrid().getSelectionModel().getSelection() == null) {
            return null;
        }
        return this.getGrid().getSelectionModel().getSelection();
    }

    public final void init() {
        this.rootPanel = new ContentPanel((Layout)new FitLayout());
        this.rootPanel.setHeaderVisible(false);
        this.widget.setId("res-details-widget-fake");
        this.widget.setStyleName("x-panel-cube-background");
        1 groupButton = new /* Unavailable Anonymous Inner Class!! */;
        groupButton.setId(btnGroupID);
        groupButton.setIconStyle("grid-icon");
        groupButton.setToolTip("Categorize");
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)groupButton);
        2 refreshButton = new /* Unavailable Anonymous Inner Class!! */;
        refreshButton.setId(btnRefreshID);
        refreshButton.setIconStyle("refresh-icon");
        refreshButton.setToolTip("Refresh");
        this.toolBar.add((Component)refreshButton);
        this.rootPanel.setTopComponent((Component)this.toolBar);
    }

    public final void toggleHighlightInvalidFields() {
        boolean bl = this.highlightInvalidFields = !this.highlightInvalidFields;
        if (this.getGridView() != null) {
            this.getGridView().refresh(true);
        }
    }

    public final ToolBar getToolBar() {
        return this.toolBar;
    }

    public final Component getWidget() {
        return this.widget;
    }

    private void disableGrouping() {
        GroupingStore groupingStore = null;
        if (this.getStore() instanceof GroupingStore) {
            groupingStore = (GroupingStore)this.getStore();
            if (groupingStore != null) {
                groupingStore.clearGrouping();
            }
            this.groupingEnabled = false;
        }
    }

    private void enableGrouping() {
        GroupingStore groupingStore = null;
        if (this.getStore() instanceof GroupingStore) {
            groupingStore = (GroupingStore)this.getStore();
            if (groupingStore != null) {
                groupingStore.groupBy(this.collapsibleColumn);
            }
            this.groupingEnabled = true;
        }
    }

    public final Grid<ModelData> getGrid() {
        if (this.getWidget() != null && this.getWidget() instanceof Grid) {
            return (Grid)this.getWidget();
        }
        return null;
    }

    private GroupingView getGridView() {
        if (this.getGrid() != null && this.getGrid().getView() instanceof GroupingView) {
            return (GroupingView)this.getGrid().getView();
        }
        return null;
    }

    public final void setWidget(Component widget, boolean enableGrouping) {
        this.rootPanel.removeAll();
        this.widget = widget;
        this.rootPanel.add((Widget)this.widget);
        Button groupButton = null;
        try {
            groupButton = (Button)this.toolBar.getItemByItemId(btnGroupID);
            groupButton.setEnabled(enableGrouping);
        }
        catch (Exception e) {
            ConsoleMessageBroker.error((Object)this, (String)("During set widget. " + e.getMessage()));
        }
    }

    public final ContentPanel getContainer() {
        return this.rootPanel;
    }

    private void resetToolBar() {
        List buttons = this.getToolBar().getItems();
        Vector<Component> toRemove = new Vector<Component>();
        if (buttons.size() > 3) {
            int i = 3;
            while (i < buttons.size()) {
                toRemove.add((Component)buttons.get(i));
                ++i;
            }
        }
        if (toRemove.size() > 0) {
            for (Component c : toRemove) {
                this.getToolBar().remove(c);
            }
        }
    }

    public final void initToolbar() {
        4 doDeploy;
        String resType = StatusHandler.getStatus().getCurrentResourceType();
        this.resetToolBar();
        if (resType.equals(ResourceTypeDecorator.GenericResource.name()) && SupportedOperations.GENERIC_RESOURCE_CREATE.isAllowed(StatusHandler.getStatus().getCredentials())) {
            this.getToolBar().add((Component)new SeparatorToolItem());
            3 createNew = new /* Unavailable Anonymous Inner Class!! */;
            createNew.setToolTip("Create new Generic Resource");
            this.getToolBar().add((Component)createNew);
        }
        if (resType.equals(ResourceTypeDecorator.Service.name()) && SupportedOperations.SERVICE_DEPLOY.isAllowed(StatusHandler.getStatus().getCredentials())) {
            this.getToolBar().add((Component)new SeparatorToolItem());
            doDeploy = new /* Unavailable Anonymous Inner Class!! */;
            doDeploy.setToolTip("Prepare a deployment plan");
            this.getToolBar().add((Component)doDeploy);
        }
        if (resType.equals(ResourceTypeDecorator.Service.name()) && SupportedOperations.SERVICE_GET_REPORT.isAllowed(StatusHandler.getStatus().getCredentials())) {
            this.getToolBar().add((Component)new SeparatorToolItem());
            doDeploy = new /* Unavailable Anonymous Inner Class!! */;
            doDeploy.setToolTip("Get report for submitted deployment");
            this.getToolBar().add((Component)doDeploy);
        }
        if (resType.equals(ResourceTypeDecorator.Service.name()) && SupportedOperations.SERVICE_DEPLOY.isAllowed(StatusHandler.getStatus().getCredentials())) {
            this.getToolBar().add((Component)new SeparatorToolItem());
            6 doAddSoftware = new /* Unavailable Anonymous Inner Class!! */;
            doAddSoftware.setToolTip("Upload software");
            this.getToolBar().add((Component)doAddSoftware);
            this.getToolBar().add((Component)new SeparatorToolItem());
        }
    }

    public final void setGrid(Grid<ModelData> grid, boolean groupingEnabled) {
        this.initToolbar();
        grid.getView().setViewConfig((GridViewConfig)new /* Unavailable Anonymous Inner Class!! */);
        grid.addListener(Events.RowClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        grid.setContextMenu(ContextMenuFactory.getInstance().buildContextMenu(StatusHandler.getStatus().getCurrentResourceType(), this));
        this.setWidget(grid, groupingEnabled);
        WidgetsRegistry.getPanel((String)"resource-detail-grid-panel").add((Widget)this.getContainer(), true);
    }

    private void openProfileInPinnedResources() {
        List selectedElems = this.getSelection();
        for (ModelData selectedElem : selectedElems) {
            String type = selectedElem.get("Type").toString();
            String resID = selectedElem.get("ID").toString();
            String scope = StatusHandler.getStatus().getCurrentScope();
            Commands.doGetResourceProfile((Object)this, (String)scope, (String)type, (String)resID);
        }
    }

    static /* synthetic */ boolean access$0(ResourceDetailsPanel resourceDetailsPanel) {
        return resourceDetailsPanel.groupingEnabled;
    }

    static /* synthetic */ void access$1(ResourceDetailsPanel resourceDetailsPanel) {
        resourceDetailsPanel.disableGrouping();
    }

    static /* synthetic */ void access$2(ResourceDetailsPanel resourceDetailsPanel) {
        resourceDetailsPanel.enableGrouping();
    }

    static /* synthetic */ boolean access$3(ResourceDetailsPanel resourceDetailsPanel) {
        return resourceDetailsPanel.highlightInvalidFields;
    }

    static /* synthetic */ void access$4(ResourceDetailsPanel resourceDetailsPanel) {
        resourceDetailsPanel.openProfileInPinnedResources();
    }
}

