let $ghns := collection('/db/Profiles/GHN')//Resource/ID
let $ris := collection('/db/Profiles/RunningInstance')//Resource
for $ri in $ris
let $counter := index-of(($ghns//ID/string()), $ri/Profile/GHN/@UniqueID/string())
where empty($counter)
return
<Resource>
    <ID>{$ri//Resource/ID/string()}</ID>
    <ServiceStatus>{$ri/Profile/DeploymentData/Status/string()}</ServiceStatus>
    <ActivationTime>{$ri/Profile/DeploymentData/ActivationTime/@value/string()}</ActivationTime>
    <ghnid>{$ri/Profile/GHN/@UniqueID/string()}</ghnid>
    <ServiceClass>{$ri/Profile/ServiceClass/string()}</ServiceClass>
    <ServiceName>{$ri/Profile/ServiceName/string()}</ServiceName>
<!--    <tmp>{$ghns//ID}</tmp> -->
    <!--
        The actions must be declared inside the SweeperAction enum declaration.
    -->
    <Actions><ACTION ISdefault ='APPLY_RI_DELETE'/></Actions>
</Resource>