/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.io.Reader;
import java.io.StringReader;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.vremanagement.ghnmanager.client.GHNManagerLibrary;
import org.gcube.common.vremanagement.ghnmanager.client.fws.Types;
import org.gcube.common.vremanagement.ghnmanager.client.proxies.Proxies;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;

public class GHNManager
extends AbstractResourceManager {
    private static final String LOG_PREFIX = "[GHN-MGR]";

    public GHNManager() throws ResourceParameterException, ResourceAccessException {
        super(AllowedResourceTypes.GHN);
    }

    public GHNManager(String id) throws ResourceParameterException, ResourceAccessException {
        super(id, AllowedResourceTypes.GHN);
    }

    public GHNManager(String id, String name) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.GHN);
    }

    public GHNManager(String id, String name, String subtype) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.GHN, subtype);
    }

    public final String addToNewScope(ScopeBean sourceScope, ScopeBean targetScope, String scopeMap) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(sourceScope != null, new ResourceParameterException("Parameter sourceScope null not allowed."));
        checker.validate(targetScope != null, new ResourceParameterException("Parameter targetScope null not allowed."));
        checker.validate(scopeMap != null && scopeMap.trim().length() > 0, new ResourceParameterException("Invalid scopeMap parameter."));
        checker.validate(this.getID() != null, new ResourceOperationException("This operation cannot be applied to resources with no ID."));
        if (!sourceScope.toString().contains(targetScope.toString())) {
            throw new ResourceOperationException("You are not allowed to apply to this scope. Target scope is not enclosed in the source one.");
        }
        ServerConsole.trace(LOG_PREFIX, "Adding from scope " + sourceScope.toString() + "Adding to existing scope " + targetScope.toString() + " " + (Object)((Object)this.getType()) + " " + this.getID());
        Types.AddScopeInputParams params = new Types.AddScopeInputParams();
        params.setScope(sourceScope.toString());
        params.setMap(scopeMap.trim());
        try {
            this.getGHNManager(sourceScope).addScope(params);
        }
        catch (Exception e) {
            throw new ResourceOperationException("Failed to add the new scope to the gHN " + this.getID() + ": " + e.getMessage());
        }
        return this.addToExistingScope(sourceScope, targetScope);
    }

    public final GHNManagerLibrary getGHNManager(ScopeBean scope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid scope"));
        checker.validate(this.getName() != null, new ResourceOperationException("This operation cannot be applied to resources with no name."));
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope.toString());
        ServerConsole.info(LOG_PREFIX, "Getting Resource Manager in scope [" + scope.toString() + "]");
        GHNManagerLibrary ghnMan = (GHNManagerLibrary)Proxies.service().build();
        if (ghnMan == null) {
            throw new ResourceAccessException("Unable to find GHNManagers for resource " + (Object)((Object)this.getType()) + " in scope: " + scope.toString());
        }
        ScopeProvider.instance.set(currScope);
        return ghnMan;
    }

    public final void shutDown(ScopeBean scope, boolean restart, boolean clean) throws AbstractResourceException {
        Assertion<ResourceAccessException> checker = new Assertion<ResourceAccessException>();
        checker.validate(this.getID() != null, new ResourceAccessException("This operation cannot be applied to resources with no ID."));
        GHNManagerLibrary ghnManager = this.getGHNManager(scope);
        ServerConsole.trace(LOG_PREFIX, "Shutting down " + scope.toString() + " " + (Object)((Object)this.getType()) + " " + this.getID());
        Types.ShutdownOptions options = new Types.ShutdownOptions();
        options.setRestart(restart);
        options.setClean(clean);
        try {
            ghnManager.shutdown(options);
        }
        catch (Exception e) {
            throw new ResourceOperationException("Cannot shutdown ghn: " + this.getID());
        }
    }

    @Override
    protected final Resource buildResource(String xmlRepresentation) throws AbstractResourceException {
        try {
            HostingNode deserialised = (HostingNode)Resources.unmarshal(HostingNode.class, (Reader)new StringReader(xmlRepresentation));
            return deserialised;
        }
        catch (Exception e) {
            throw new ResourceAccessException("Cannot load the stub for resource " + (Object)((Object)this.getType()), e);
        }
    }
}

