/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.vremanagement.resourcemanager.client.RMReportingLibrary;

public class RuntimeResourceManager
extends AbstractResourceManager {
    private static RuntimeResourceManager singleton = null;
    private static final String LOG_PREFIX = "[RR-MGR]";

    public RuntimeResourceManager() throws ResourceParameterException, ResourceAccessException {
        super(AllowedResourceTypes.RuntimeResource);
    }

    public RuntimeResourceManager(String id) throws ResourceParameterException, ResourceAccessException {
        super(id, AllowedResourceTypes.RuntimeResource);
    }

    public RuntimeResourceManager(String id, String name) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.RuntimeResource);
    }

    public RuntimeResourceManager(String id, String name, String subType) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.RuntimeResource, subType);
    }

    public final String checkDeployStatus(ScopeBean scope, String deployID) throws AbstractResourceException {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid scope passed"));
        checker.validate(deployID != null && deployID.trim().length() > 0, new ResourceParameterException("Invalid reportID passed"));
        RMReportingLibrary vreManagerPortType = this.getReportResourceManager(scope.name());
        try {
            return vreManagerPortType.getReport(deployID);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
            throw new ResourceOperationException("Cannot retrieve the report: " + deployID + " " + e.getMessage());
        }
    }

    @Override
    protected final Resource buildResource(String xmlRepresentation) throws AbstractResourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ServiceEndpoint.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            StringReader reader = new StringReader(xmlRepresentation);
            ServiceEndpoint deserialised = (ServiceEndpoint)unmarshaller.unmarshal((Reader)reader);
            return deserialised;
        }
        catch (Exception e) {
            throw new ResourceAccessException("Cannot load the stub for resource " + (Object)((Object)this.getType()), e);
        }
    }

    static {
        if (singleton == null) {
            try {
                singleton = new RuntimeResourceManager("dummyservice", "dummyservice");
            }
            catch (Exception e) {
                ServerConsole.error(LOG_PREFIX, e);
            }
        }
    }
}

