/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.shared.util;

import java.util.HashMap;
import java.util.Map;

public class PerformanceMonitor {
    private long startMills = 0L;
    private long stopMills = 0L;
    private long lastInterval = 0L;
    private long intermediateInterval = 0L;
    private StackTraceElement caller = null;
    public String ownerID = null;
    private static final Map<String, PerformanceMonitor> clocks = new HashMap<String, PerformanceMonitor>();

    private StackTraceElement getCaller(int depth) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        StackTraceElement position = ste[ste.length - 1 - depth];
        return position;
    }

    public static PerformanceMonitor getClock(String ownerID) {
        if (clocks.containsKey(ownerID)) {
            return clocks.get(ownerID);
        }
        PerformanceMonitor retval = new PerformanceMonitor(ownerID);
        clocks.put(ownerID, retval);
        return retval;
    }

    public static PerformanceMonitor getClock(Class<?> owner) {
        return PerformanceMonitor.getClock(owner.getName());
    }

    private PerformanceMonitor(String owner) {
        this.ownerID = owner;
        this.caller = this.getCaller(1);
    }

    public final void start() {
        this.startMills = System.currentTimeMillis();
        this.stopMills = 0L;
        this.lastInterval = 0L;
        this.intermediateInterval = 0L;
    }

    public final float stop(boolean relative) {
        this.stopMills = System.currentTimeMillis();
        this.intermediateInterval = this.stopMills - this.startMills - this.lastInterval;
        this.lastInterval = this.stopMills - this.startMills;
        if (relative) {
            return this.getIntermediateIntervalSecs();
        }
        return this.getLastIntervalSecs();
    }

    private final float getIntermediateIntervalSecs() {
        if (this.intermediateInterval == 0L) {
            return 0.0f;
        }
        return (float)this.intermediateInterval / 1000.0f;
    }

    private final float getLastIntervalSecs() {
        if (this.lastInterval == 0L) {
            return 0.0f;
        }
        return (float)this.lastInterval / 1000.0f;
    }

    public final StackTraceElement getCaller() {
        return this.caller;
    }

    public final String getOwnerID() {
        return this.ownerID;
    }
}

