package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import javax.servlet.http.HttpSession;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.DispatchException;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetScope;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetScopeResult;
import org.slf4j.Logger;

import com.google.inject.Inject;
import com.google.inject.Provider;

public class SetScopeHandler implements ActionHandler<SetScope, SetScopeResult> {
	
	Provider<HttpSession> sessionProvider;
	
	@InjectLogger
	Logger logger;
	
	@Inject
	public SetScopeHandler(Provider<HttpSession> sessionProvider) {
		this.sessionProvider = sessionProvider;
	}

	@Override
	public SetScopeResult execute(SetScope scopeAction, ExecutionContext context)
			throws DispatchException {
		HttpSession session = sessionProvider.get();
		session.setAttribute(GCUBEScope.class.getName(), scopeAction.getScope());
		logger.debug("Scope set to: " + scopeAction.getScope());
		return new SetScopeResult();
	}

	@Override
	public Class<SetScope> getActionType() {
		return SetScope.class;
	}

	@Override
	public void rollback(SetScope arg0, SetScopeResult arg1,
			ExecutionContext arg2) throws DispatchException {
		// TODO Auto-generated method stub
		
	}

}
