package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import org.gcube.portlets.admin.software_upload_wizard.server.importmanagers.ImportSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.GetGenericData;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.GetGenericDataResult;
import org.slf4j.Logger;

import com.google.inject.Inject;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import net.customware.gwt.dispatch.shared.DispatchException;

public class GetGenericDataHandler implements
		ActionHandler<GetGenericData, GetGenericDataResult> {

	@InjectLogger
	Logger logger;

	ImportSessionManager importSessionManager;

	@Inject
	public GetGenericDataHandler(ImportSessionManager importSessionManager) {
		super();
		this.importSessionManager = importSessionManager;
	}

	@Override
	public Class<GetGenericData> getActionType() {
		return GetGenericData.class;
	}

	@Override
	public GetGenericDataResult execute(GetGenericData action,
			ExecutionContext context) throws DispatchException {
		try {
			Object obj = importSessionManager.getImportSession()
					.getGenericData(action.getKey());
			return new GetGenericDataResult(obj);
		} catch (Exception e) {
			throw new ActionException(e);
		}
	}

	@Override
	public void rollback(GetGenericData action, GetGenericDataResult result,
			ExecutionContext context) throws DispatchException {
	}

}
