/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.vremanagement.vremanagement.impl.VREGeneratorEvo;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionService;
import org.gcube.portlets.admin.vredefinition.shared.Functionality;
import org.gcube.portlets.admin.vredefinition.shared.Resource;
import org.gcube.portlets.admin.vredefinition.shared.ResourceCategory;
import org.gcube.portlets.admin.vredefinition.shared.VREDescriptionBean;
import org.gcube.portlets.admin.vredefinition.shared.exception.VREDefinitionException;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vremanagement.vremodel.cl.stubs.types.FunctionalityItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.SelectedResourceDescriptionType;
import org.gcube.vremanagement.vremodel.cl.stubs.types.VREDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VREDefinitionServiceImpl
extends RemoteServiceServlet
implements VREDefinitionService {
    private static final long serialVersionUID = -7581858549584810224L;
    private static final Logger logger = LoggerFactory.getLogger(VREDefinitionServiceImpl.class);
    private static final String DESIGNER = "Designer";
    private static final String MANAGER = "Manager";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String VRE_MANAGER_STRING = "VRE-Manager";
    private static final String VRE_DEFINER_GENERATOR_ATTRIBUTE = "VREDefinerGenerator";
    private static final String VRE_GENERATOR_ATTRIBUTE = "VREGenerator";
    private static final String REEDIT_TYPE_ATTRIBUTE = "reeditType";
    private static final String EDIT_MODE = "edit";
    private static final String APPROVE_MODE = "approve";
    private static final String VRE_NAME_FIELD = "vreName";
    private static final String VRE_MANAGER_FIELD = "vreManager";
    private static final String VRE_DESIGNER_FIELD = "vreDesigner";
    private static final String VRE_DESCRIPTION_FIELD = "vreDescription";
    private static final String VRE_START_TIME_FIELD = "vreStartTime";
    private static final String VRE_END_TIME_FIELD = "vreEndTime";
    public static final String defaultUserId = "test.user";
    private static final String voID = "/gcube/devsec";

    public void init() {
        logger.debug("Servlet init");
    }

    public void destroy() {
        logger.debug("Servlet destroyed");
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            logger.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope(voID);
            SessionManager.getInstance().getASLSession(sessionID, user).setAttribute(REEDIT_TYPE_ATTRIBUTE, (Object)APPROVE_MODE);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            logger.trace("Development Mode ON");
            return false;
        }
    }

    public String getDevelopmentUser() {
        String user = defaultUserId;
        return user;
    }

    public Map<String, Serializable> getVRE() {
        HashMap<String, Serializable> toReturn;
        block7: {
            logger.debug("########### INVOKED getVRE() METHOD ###########");
            toReturn = new HashMap<String, Serializable>();
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            if (!this.isWithinPortal()) {
                logger.debug("You are in dev mode");
                return this.getFakeVreDefinition();
            }
            boolean editMode = this.isEditMode();
            logger.debug("EDIT MODE IS " + editMode);
            toReturn.put(EDIT_MODE, Boolean.valueOf(editMode));
            try {
                LiferayUserManager um = new LiferayUserManager();
                LiferayRoleManager rm = new LiferayRoleManager();
                long voOrgID = this.getASLSession().getGroupId();
                long roleId = rm.getRoleId(VRE_MANAGER_STRING, this.getASLSession().getGroupId());
                logger.debug("VRE-Manager has role id " + roleId + " into organization " + voOrgID);
                logger.debug("Trying to get roleid of VRE-Manager into " + this.getASLSession().getGroupName());
                List belongingUsers = um.listUsersByGroupAndRole(voOrgID, roleId);
                logger.debug("Number of managers is " + belongingUsers.size());
                ArrayList<String> managers = new ArrayList<String>();
                for (int i = 0; i < belongingUsers.size(); ++i) {
                    managers.add(((GCubeUser)belongingUsers.get(i)).getFullname() + " (" + ((GCubeUser)belongingUsers.get(i)).getUsername() + ")");
                }
                toReturn.put(MANAGER, managers);
                logger.debug("Managers set as " + managers);
                String fullName = um.getUserByUsername(username).getFullname();
                toReturn.put(DESIGNER, (Serializable)((Object)(fullName + " (" + username + ")")));
                logger.debug("Designer set as " + fullName + " (" + username + ")");
                if (!editMode) break block7;
                try {
                    VREDescriptionBean vreBean = this.getVREInSession();
                    if (vreBean != null) {
                        toReturn.put(VRE_NAME_FIELD, (Serializable)((Object)vreBean.getName()));
                        toReturn.put(VRE_MANAGER_FIELD, (Serializable)((Object)vreBean.getManager()));
                        toReturn.put(VRE_DESIGNER_FIELD, (Serializable)((Object)(fullName + " (" + vreBean.getDesigner() + ")")));
                        toReturn.put(VRE_DESCRIPTION_FIELD, (Serializable)((Object)vreBean.getDescription()));
                        toReturn.put(VRE_START_TIME_FIELD, vreBean.getStartTime());
                        toReturn.put(VRE_END_TIME_FIELD, vreBean.getEndTime());
                    }
                }
                catch (Exception e) {
                    logger.error("Error while retrieving vre description bean", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Error while retrieving vre information", (Throwable)e);
            }
        }
        return toReturn;
    }

    private Map<String, Serializable> getFakeVreDefinition() {
        HashMap<String, Serializable> toReturn = new HashMap<String, Serializable>();
        ArrayList<String> managers = new ArrayList<String>();
        managers.add("Pasquale Pagano (pasquale.pagano)");
        managers.add("Andrea Manzi (andrea.manzi)");
        managers.add("Massimiliano Assante (massimiliano.assante)");
        toReturn.put(MANAGER, managers);
        toReturn.put(DESIGNER, (Serializable)((Object)"Leonardo Candela (leonardo.candela)"));
        boolean editMode = this.isEditMode();
        toReturn.put(EDIT_MODE, Boolean.valueOf(editMode));
        if (editMode) {
            try {
                VREDescriptionBean vreBean = this.getVREInSession();
                if (vreBean != null) {
                    logger.debug(" ########### VRE != NULL ##########");
                    logger.debug("Bean is " + vreBean);
                    toReturn.put(VRE_NAME_FIELD, (Serializable)((Object)vreBean.getName()));
                    toReturn.put(VRE_MANAGER_FIELD, (Serializable)((Object)vreBean.getManager()));
                    toReturn.put(VRE_DESIGNER_FIELD, (Serializable)((Object)vreBean.getDesigner()));
                    toReturn.put(VRE_DESCRIPTION_FIELD, (Serializable)((Object)vreBean.getDescription()));
                    toReturn.put(VRE_START_TIME_FIELD, Long.valueOf(vreBean.getStartTime().getTime()));
                    toReturn.put(VRE_END_TIME_FIELD, Long.valueOf(vreBean.getEndTime().getTime()));
                }
            }
            catch (Exception e1) {
                logger.error("Missing definition bean...");
            }
        }
        return toReturn;
    }

    private VREDescriptionBean getVREInSession() throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        VREDescriptionBean vreDescBean = null;
        try {
            VREDescription sd = vreGenerator.getVREModel();
            vreDescBean = new VREDescriptionBean(sd.name(), sd.description(), sd.designer(), sd.manager(), sd.startTime().getTime(), sd.endTime().getTime());
        }
        catch (RemoteException e) {
            throw new VREDefinitionException("Fail retrieve VRE");
        }
        logger.debug("Model retrieved is " + vreDescBean);
        return vreDescBean;
    }

    private VREGeneratorEvo getVREGenerator() {
        ASLSession d4ScienceSession = this.getASLSession();
        VREGeneratorEvo vreGenerator = (VREGeneratorEvo)d4ScienceSession.getAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE);
        if (vreGenerator == null) {
            logger.debug("There is no VREGeneratorEvo in the session, adding it..");
            vreGenerator = new VREGeneratorEvo(d4ScienceSession);
            d4ScienceSession.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
        }
        return vreGenerator;
    }

    private boolean isEditMode() {
        logger.debug("Checking if we are in edit mode...");
        ASLSession session = this.getASLSession();
        String reeditType = (String)session.getAttribute(REEDIT_TYPE_ATTRIBUTE);
        session.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
        if (reeditType != null && reeditType.equals(EDIT_MODE)) {
            String vreid = (String)session.getAttribute(VRE_GENERATOR_ATTRIBUTE);
            if (vreid != null) {
                VREGeneratorEvo vreGenerator = new VREGeneratorEvo(session, vreid);
                session.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
            }
            session.setAttribute(REEDIT_TYPE_ATTRIBUTE, null);
            return true;
        }
        return false;
    }

    public ArrayList<Functionality> getFunctionality(boolean isEdit) throws VREDefinitionException {
        if (!isEdit) {
            Calendar cal = Calendar.getInstance();
            long startTime = cal.getTimeInMillis();
            cal.add(2, 5);
            cal.add(10, 7);
            long endTime = cal.getTimeInMillis();
            try {
                this.getVREGenerator().setVREModel("notCompletedVirtualResearchEnv.", UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), startTime, endTime);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("Error on setVREModel()", (Throwable)e);
            }
        }
        if (!this.getVREGenerator().isVreModelerServiceUp()) {
            return null;
        }
        ArrayList<Functionality> toReturn = new ArrayList<Functionality>();
        try {
            List listMainFunctionalities = this.getVREGenerator().getFunctionality();
            if (listMainFunctionalities != null && !listMainFunctionalities.isEmpty()) {
                for (FunctionalityItem functionalityItem : listMainFunctionalities) {
                    logger.debug("Reading FunctionalityItem with id:" + functionalityItem.id() + " and name " + functionalityItem.name());
                    Functionality mainFunctionality = new Functionality(functionalityItem.id(), functionalityItem.name(), functionalityItem.description(), functionalityItem.selected());
                    toReturn.add(mainFunctionality);
                    if (functionalityItem.children() == null || functionalityItem.children().isEmpty()) {
                        logger.debug(functionalityItem.name() + " has no children.");
                        continue;
                    }
                    List childrenFunctionalities = functionalityItem.children();
                    ArrayList<Functionality> subFunctionalities = new ArrayList<Functionality>();
                    for (FunctionalityItem childFunctionality : childrenFunctionalities) {
                        logger.debug("Reading child FunctionalityItem " + childFunctionality.name() + " of node " + functionalityItem.name());
                        Functionality subFunctionality = new Functionality(childFunctionality.id(), childFunctionality.name(), childFunctionality.description(), childFunctionality.selected());
                        List resourcesDescriptionItems = childFunctionality.selectableResourcesDescription();
                        if (resourcesDescriptionItems != null && !resourcesDescriptionItems.isEmpty()) {
                            ArrayList<ResourceCategory> categories = new ArrayList<ResourceCategory>();
                            for (ResourceDescriptionItem resourceDescriptionItem : resourcesDescriptionItems) {
                                logger.debug("Reading ResourceDescriptionItem " + resourceDescriptionItem.description() + " of functionality " + childFunctionality.name());
                                List resourceItems = resourceDescriptionItem.resources();
                                if (resourceItems == null || resourceItems.isEmpty()) continue;
                                ResourceCategory rc = new ResourceCategory(resourceDescriptionItem.id(), resourceDescriptionItem.description());
                                ArrayList<Resource> resourceModels = new ArrayList<Resource>();
                                for (ResourceItem resource : resourceDescriptionItem.resources()) {
                                    logger.debug("Reading resource " + resource.name() + " of ResourceDescriptionItem " + resourceDescriptionItem.description());
                                    resourceModels.add(new Resource(resource.id(), resource.name(), resource.description(), resource.selected()));
                                }
                                rc.setItems(resourceModels);
                                categories.add(rc);
                            }
                            subFunctionality.setResources(categories);
                        }
                        subFunctionalities.add(subFunctionality);
                    }
                    mainFunctionality.setSubFunctionalities(subFunctionalities);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving the list of functionalities", (Throwable)e);
            return null;
        }
        return toReturn;
    }

    private boolean setFunctionalities(List<Functionality> functionalities) {
        ArrayList<SelectedResourceDescriptionType> toSend = new ArrayList<SelectedResourceDescriptionType>();
        ArrayList<Integer> subfunctionalitiesIDS = new ArrayList<Integer>();
        for (Functionality macroFunctionality : functionalities) {
            logger.debug("Scanning macro functionality " + macroFunctionality.getName());
            List subfunctionalities = macroFunctionality.getSubFunctionalities();
            for (Functionality subfunctionality : subfunctionalities) {
                logger.debug("Scanning sub functionality " + subfunctionality.getName());
                if (!subfunctionality.isSelected()) continue;
                logger.debug("This subfunctionality was selected");
                subfunctionalitiesIDS.add(subfunctionality.getId());
                List categories = subfunctionality.getResources();
                if (categories == null) continue;
                for (ResourceCategory category : categories) {
                    String descriptionId = category.getId();
                    ArrayList resources = category.getItems();
                    ArrayList<String> resourceIds = new ArrayList<String>();
                    if (resources != null) {
                        logger.debug("Scanning resources of " + subfunctionality.getName());
                        for (Resource resource : resources) {
                            if (!resource.isSelected()) continue;
                            logger.debug("Resource of " + resource.getName() + " was selected by the user");
                            resourceIds.add(resource.getId());
                        }
                    }
                    SelectedResourceDescriptionType toAdd = new SelectedResourceDescriptionType();
                    toAdd.descriptionId(descriptionId);
                    toAdd.resourceIds(resourceIds);
                    toSend.add(toAdd);
                }
            }
        }
        Integer[] funcIdAsInts = subfunctionalitiesIDS.toArray(new Integer[subfunctionalitiesIDS.size()]);
        SelectedResourceDescriptionType[] selres = toSend.toArray(new SelectedResourceDescriptionType[toSend.size()]);
        logger.debug("SelectedResourceDescriptionType[] Sending to Service .... toSend size = " + toSend.size());
        for (int i = 0; i < selres.length; ++i) {
            logger.debug("SelectedResourceDescriptionType DESC: " + selres[i].getDescriptionId());
            for (int j = 0; j < selres[i].resourceIds().size(); ++j) {
                logger.debug("resid= " + (String)selres[i].resourceIds().get(j));
            }
        }
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        try {
            vreGenerator.setFunctionality(funcIdAsInts, selres);
            vreGenerator.setVREtoPendingState();
            return true;
        }
        catch (RemoteException e) {
            logger.error("An error arises", (Throwable)e);
            return false;
        }
    }

    public boolean setVRE(VREDescriptionBean bean, ArrayList<Functionality> functionalities) throws VREDefinitionException {
        String completeDesigner = bean.getDesigner();
        bean.setDesigner(this.extractUserName(completeDesigner));
        String managerUserName = this.extractUserName(bean.getManager());
        bean.setManager(managerUserName);
        this.setVREDescription(bean);
        this.setFunctionalities(functionalities);
        try {
            this.getVREGenerator().setVREtoPendingState();
            this.getASLSession().setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
            Workspace workspace = HomeLibrary.getUserWorkspace((String)this.getASLSession().getUsername());
            ArrayList<String> toSend = new ArrayList<String>();
            toSend.add(managerUserName);
            String subject = "New VRE Definition requires your approval";
            String body = "Dear Manager, \n\n" + completeDesigner + " has created a VRE Definition indicating you as VRE Manager on " + this.getASLSession().getScope();
            body = body + ".\n\nThe VRE Name is: " + bean.getName() + ", the VRE Description is: " + bean.getDescription() + ".";
            String messagedId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), toSend);
            ASLSession session = this.getASLSession();
            SocialNetworkingUser user = new SocialNetworkingUser(session.getUsername(), session.getUserEmailAddress(), session.getUserFullName(), session.getUserAvatarId());
            ApplicationNotificationsManager nnm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), session.getScope(), user);
            if (nnm.notifyMessageReceived(managerUserName, messagedId, subject, body, new String[0])) {
                logger.trace("Sending VRE Definition create notification: " + subject + " OK");
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error while creating the new VRE ", (Throwable)e);
            return false;
        }
    }

    private String setVREDescription(VREDescriptionBean bean) throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        ASLSession d4ScienceSession = this.getASLSession();
        d4ScienceSession.setAttribute(VRE_NAME_FIELD, (Object)bean.getName());
        d4ScienceSession.setAttribute(DESCRIPTION, (Object)bean.getDescription());
        d4ScienceSession.setAttribute(DESIGNER, (Object)bean.getDesigner());
        d4ScienceSession.setAttribute(MANAGER, (Object)bean.getManager());
        try {
            vreGenerator.setVREModel(bean.getName(), bean.getDescription(), bean.getDesigner(), bean.getManager(), bean.getStartTime().getTime(), bean.getEndTime().getTime());
        }
        catch (RemoteException e) {
            logger.error("An error arises", (Throwable)e);
            throw new VREDefinitionException("Set Description Error");
        }
        return null;
    }

    private String extractUserName(String toExtract) {
        int openBracket = toExtract.indexOf("(") + 1;
        int closeBracket = toExtract.indexOf(")");
        String toReturn = toExtract.substring(openBracket, closeBracket);
        logger.debug("Extracted username is " + toReturn);
        return toReturn;
    }
}

