/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.client.ui;

import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.datepicker.client.ui.DateBoxAppended;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.gcube.portlets.admin.vredefinition.client.ui.VRECreationFormSkeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VRECreationFormSkeleton
extends Composite {
    private static VRECreationFormSkeletonUiBinder uiBinder = (VRECreationFormSkeletonUiBinder)GWT.create(VRECreationFormSkeletonUiBinder.class);
    @UiField
    VerticalPanel vreFunctionalities;
    @UiField
    DateBoxAppended vreFromDate;
    @UiField
    DateBoxAppended vreToDate;
    @UiField
    TextBox vreNameTextBox;
    @UiField
    TextBox vreDesignerTextBox;
    @UiField
    ListBox vreManagersListBox;
    @UiField
    TextArea vreDescriptionTextArea;
    @UiField
    HelpInline vreNameError;
    @UiField
    HelpInline vreDescriptionError;
    @UiField
    HelpInline vreDesignerError;
    public static final String imagePath = GWT.getModuleBaseURL() + "../images/statistics-loader.gif";

    public VRECreationFormSkeleton() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        Date end = this.vreFromDate.getValue();
        end.setYear(end.getYear() + 1);
        this.vreToDate.setValue(end);
    }

    public void appendRow(Widget child) {
        if (child.getClass().equals(Row.class)) {
            this.vreFunctionalities.add(child);
        }
    }

    @UiHandler(value={"vreFromDate"})
    void ChangeHandlerStart(ValueChangeEvent<Date> event) {
        GWT.log((String)"Change handler FROM");
        Date current = new Date();
        Date selected = this.vreFromDate.getValue();
        if (selected.compareTo(current) < 0) {
            this.vreFromDate.setValue(current);
        }
    }

    @UiHandler(value={"vreToDate"})
    void ChangeHandlerTo(ValueChangeEvent<Date> event) {
        GWT.log((String)"Change handler TO");
        Date start = this.vreFromDate.getValue();
        Date selected = this.vreToDate.getValue();
        if (selected.compareTo(start) < 0) {
            Date end = this.vreFromDate.getValue();
            end.setYear(end.getYear() + 1);
            this.vreToDate.setValue(end);
        }
    }

    public void removeLoader() {
        this.vreFunctionalities.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.vreFunctionalities.clear();
    }

    public void showLoader() {
        this.vreFunctionalities.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.vreFunctionalities.setWidth("100%");
        this.vreFunctionalities.add((Widget)new Image(imagePath));
    }

    public String getCurrentVREName() {
        return this.vreNameTextBox.getText();
    }

    public String getCurrentVREDesigner() {
        return this.vreDesignerTextBox.getText();
    }

    public String getCurrentVREManager() {
        GWT.log((String)("Selected manager is " + this.vreManagersListBox.getSelectedItemText()));
        return this.vreManagersListBox.getSelectedItemText();
    }

    public String getCurrentVREDescription() {
        return this.vreDescriptionTextArea.getText();
    }

    public Date getCurrentVREStartDate() {
        return this.vreFromDate.getValue();
    }

    public Date getCurrentVREToDate() {
        return this.vreToDate.getValue();
    }

    public void setVREDesigner(String designer) {
        this.vreDesignerTextBox.setText(designer);
    }

    public void setVREManagers(List<String> managers, String selectedManager) {
        Collections.sort(managers);
        for (String manager : managers) {
            this.vreManagersListBox.addItem(manager);
        }
        if (selectedManager != null) {
            this.vreManagersListBox.setSelectedValue(selectedManager);
        }
    }

    public void showAlertBlockVREName() {
        this.vreNameError.setVisible(true);
        this.vreNameTextBox.setFocus(true);
        this.vreNameTextBox.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.vreNameTextBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showAlertBlockVREDescritption() {
        this.vreDescriptionError.setVisible(true);
        this.vreDescriptionTextArea.setFocus(true);
        this.vreDescriptionTextArea.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.vreDescriptionTextArea.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setVREName(String vreName) {
        this.vreNameTextBox.setText(vreName);
    }

    public void setVREDescription(String description) {
        this.vreDescriptionTextArea.setText(description);
    }

    public void setVREFromDate(Date startDate) {
        this.vreFromDate.setValue(startDate);
    }

    public void setVREToDate(Date toDate) {
        this.vreToDate.setValue(toDate);
    }
}

