/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.client.ui;

import com.github.gwtbootstrap.client.ui.AppendButton;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.SimplePager;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.gcube.portlets.admin.vredefinition.client.ui.ResourcesTable;
import org.gcube.portlets.admin.vredefinition.shared.Resource;

public class ResourcesTable
extends Composite {
    protected ListDataProvider<Resource> dataProvider = new ListDataProvider();
    private CellTable<Resource> table = new CellTable();
    private List<Resource> originalResources;
    private static final int MAX_ROW_TO_SHOW_BEGINNING = 10;
    private TextBox searchBox;
    private Button searchButton;
    private Boolean isFilteringEnabled = false;
    private Button showAllButton = new Button();
    private Button selectAllRows = new Button();
    private boolean allRowsSelected = false;
    private VerticalPanel mainPanel = new VerticalPanel();
    private int checkedResourcesNumber = 0;

    public ResourcesTable(List<Resource> resources, AppendButton apButton, CheckBox checkBoxSubfunctionality) {
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.setWidth("100%");
        this.originalResources = resources;
        this.dataProvider.setList(resources);
        this.dataProvider.addDataDisplay((HasData)this.table);
        this.table.setStriped(true);
        this.table.setWidth("100%", false);
        this.table.addStyleName("table-style");
        this.table.setBordered(true);
        this.table.setVisibleRange(new Range(0, 10));
        this.table.setRowCount(resources.size(), true);
        this.searchBox = (TextBox)apButton.getWidget(0);
        this.searchButton = (Button)apButton.getWidget(1);
        this.searchBox.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.searchButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        3 chosenColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.table.addColumn((Column)chosenColumn, "Select");
        4 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        ColumnSortEvent.ListHandler nameColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        nameColHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        nameColumn.setSortable(true);
        nameColumn.setDefaultSortAscending(false);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)nameColHandler);
        this.table.addColumn((Column)nameColumn, "Name");
        6 descColumn = new /* Unavailable Anonymous Inner Class!! */;
        ColumnSortEvent.ListHandler descColHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        descColHandler.setComparator((Column)descColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        descColumn.setSortable(true);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)descColHandler);
        this.table.addColumn((Column)descColumn, "Description");
        this.table.getColumnSortList().push((Column)nameColumn);
        this.table.setColumnWidth((Column)chosenColumn, 60.0, Style.Unit.PX);
        FlowPanel controlPanel = new FlowPanel();
        this.showAllButton.setText("Show all resources");
        this.showAllButton.addStyleName("show-all-resources-button");
        this.showAllButton.setTitle("Show all resources");
        this.selectAllRows.setText("Select all resources");
        this.selectAllRows.setTitle("Select all resources of the table");
        this.addShowButtonsHandler();
        this.addselectAllRowsHandler(checkBoxSubfunctionality);
        if (resources.size() > 10) {
            controlPanel.add((Widget)this.showAllButton);
        }
        if (resources.size() > 0) {
            controlPanel.add((Widget)this.selectAllRows);
        }
        this.mainPanel.add((Widget)controlPanel);
        SimplePager pager = new SimplePager(SimplePager.TextLocation.RIGHT);
        pager.setPageSize(10);
        pager.setDisplay((HasRows)this.table);
        pager.getElement().getStyle().setMarginTop(20.0, Style.Unit.PX);
        this.mainPanel.add((Widget)pager);
        this.mainPanel.add((Widget)this.table);
    }

    private void addselectAllRowsHandler(CheckBox checkBoxSubfunctionality) {
        this.selectAllRows.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addShowButtonsHandler() {
        this.showAllButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void searchOnClickEvent(ClickEvent event, boolean[] isFilteringEnabledReference) {
        if (isFilteringEnabledReference[0]) {
            this.searchButton.setIcon(IconType.SEARCH);
            this.searchBox.setText("");
            isFilteringEnabledReference[0] = false;
            this.dataProvider.setList(this.originalResources);
            this.table.setVisibleRange(new Range(0, 10));
            this.table.setRowCount(this.dataProvider.getList().size(), true);
            this.dataProvider.refresh();
        } else if (!this.searchBox.getText().isEmpty()) {
            String filter = this.searchBox.getText();
            List currentList = this.dataProvider.getList();
            ArrayList<Resource> toShow = new ArrayList<Resource>();
            for (Resource resource : currentList) {
                String filterLowerCase;
                String nameLowerCase = resource.getName().toLowerCase();
                if (!nameLowerCase.contains(filterLowerCase = filter.toLowerCase())) continue;
                toShow.add(resource);
            }
            this.dataProvider.setList(toShow);
            this.table.setVisibleRange(new Range(0, 10));
            this.table.setRowCount(this.dataProvider.getList().size(), true);
            this.dataProvider.refresh();
            this.searchButton.setIcon(IconType.REMOVE_SIGN);
            this.searchButton.setTitle("Remove search");
            isFilteringEnabledReference[0] = true;
        }
    }

    private void searchOnKeyDown(KeyDownEvent event) {
        if (event.getNativeKeyCode() == 13) {
            if (!this.searchBox.getText().isEmpty()) {
                String filter = this.searchBox.getText();
                List currentList = this.dataProvider.getList();
                ArrayList<Resource> toShow = new ArrayList<Resource>();
                for (Resource resource : currentList) {
                    String filterLowerCase;
                    String nameLowerCase = resource.getName().toLowerCase();
                    if (!nameLowerCase.contains(filterLowerCase = filter.toLowerCase())) continue;
                    toShow.add(resource);
                }
                this.dataProvider.setList(toShow);
                this.table.setVisibleRange(new Range(0, 10));
                this.table.setRowCount(this.dataProvider.getList().size(), true);
                this.dataProvider.refresh();
            } else {
                this.dataProvider.setList(this.originalResources);
                this.table.setVisibleRange(new Range(0, 10));
                this.table.setRowCount(this.dataProvider.getList().size(), true);
                this.dataProvider.refresh();
                this.searchButton.setIcon(IconType.SEARCH);
            }
        }
    }

    static /* synthetic */ void access$000(ResourcesTable x0, KeyDownEvent x1) {
        x0.searchOnKeyDown(x1);
    }

    static /* synthetic */ Boolean access$100(ResourcesTable x0) {
        return x0.isFilteringEnabled;
    }

    static /* synthetic */ void access$200(ResourcesTable x0, ClickEvent x1, boolean[] x2) {
        x0.searchOnClickEvent(x1, x2);
    }

    static /* synthetic */ Boolean access$102(ResourcesTable x0, Boolean x1) {
        x0.isFilteringEnabled = x1;
        return x0.isFilteringEnabled;
    }

    static /* synthetic */ int access$302(ResourcesTable x0, int x1) {
        x0.checkedResourcesNumber = x1;
        return x0.checkedResourcesNumber;
    }

    static /* synthetic */ int access$300(ResourcesTable x0) {
        return x0.checkedResourcesNumber;
    }

    static /* synthetic */ boolean access$400(ResourcesTable x0) {
        return x0.allRowsSelected;
    }

    static /* synthetic */ boolean access$402(ResourcesTable x0, boolean x1) {
        x0.allRowsSelected = x1;
        return x0.allRowsSelected;
    }

    static /* synthetic */ Button access$500(ResourcesTable x0) {
        return x0.selectAllRows;
    }

    static /* synthetic */ CellTable access$600(ResourcesTable x0) {
        return x0.table;
    }

    static /* synthetic */ Button access$700(ResourcesTable x0) {
        return x0.showAllButton;
    }
}

