/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wfdocviewer.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.admin.wfdocslibrary.server.db.MyDerbyStore;
import org.gcube.portlets.admin.wfdocslibrary.server.db.Store;
import org.gcube.portlets.admin.wfdocslibrary.shared.ForwardAction;
import org.gcube.portlets.admin.wfdocslibrary.shared.LogAction;
import org.gcube.portlets.admin.wfdocslibrary.shared.Step;
import org.gcube.portlets.admin.wfdocslibrary.shared.UserInfo;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraph;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfGraphDetails;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRole;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRoleDetails;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfTemplate;
import org.gcube.portlets.admin.wfdocviewer.client.WorkflowDocService;
import org.gcube.portlets.admin.wfdocviewer.server.DocLibraryUtil;
import org.gcube.portlets.admin.wfdocviewer.server.loggers.CreatedWorkflowReportLogEntry;
import org.gcube.portlets.admin.wfdocviewer.server.loggers.DeletedWorkflowLogEntry;
import org.gcube.portlets.admin.wfdocviewer.shared.ActionLogBean;
import org.gcube.portlets.admin.wfdocviewer.shared.UserBean;
import org.gcube.portlets.admin.wfdocviewer.shared.WfDocumentBean;
import org.gcube.portlets.admin.wfdocviewer.shared.WfTemplateBean;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowDocServiceImpl
extends RemoteServiceServlet
implements WorkflowDocService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDocServiceImpl.class);
    private static final int LIFERAY_ORGANIZATION_ROLE_ID = 3;
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";
    private Store store;
    private XStream xstream;
    boolean isTesting = false;

    public void init() {
        this.store = new MyDerbyStore();
        this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            user = "federico.defaveri";
            this.getThreadLocalRequest().getSession().setAttribute("username", (Object)user);
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devNext");
            this.isTesting = true;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ArrayList<WfDocumentBean> getAllWfDocuments() {
        ArrayList<WfDocumentBean> toRet = new ArrayList<WfDocumentBean>();
        Workspace root = null;
        String serverName = this.getThreadLocalRequest().getServerName();
        try {
            root = this.getWorkspaceArea();
            for (WorkspaceItem item : root.getRoot().getChildren()) {
                FolderItem fi;
                if (item.getType() != WorkspaceItemType.FOLDER_ITEM || (fi = (FolderItem)item).getFolderItemType() != FolderItemType.WORKFLOW_REPORT) continue;
                log.debug("Check if workflow report belongs to " + serverName);
                String storedServerName = fi.getDescription();
                storedServerName = storedServerName.substring(storedServerName.indexOf(".") + 1, storedServerName.length());
                String currServerName = serverName.substring(serverName.indexOf(".") + 1, serverName.length());
                if (storedServerName.compareTo(currServerName) == 0) {
                    log.debug("workflow report does belong to " + currServerName);
                    String wfId = (String)fi.getProperties().getProperties().get(NodeProperty.WORKFLOW_ID.toString());
                    WfGraphDetails g = this.store.getWorkflowById(wfId);
                    ArrayList actions = this.fetchActionsByWorkflowId(wfId);
                    ActionLogBean lastAction = null;
                    lastAction = actions.size() > 0 ? (ActionLogBean)actions.get(actions.size() - 1) : new ActionLogBean(wfId, fi.getCreationTime().getTime(), this.getDisplaynameByUsername(this.getASLSession().getUsername()), "Created");
                    WfDocumentBean toAdd = new WfDocumentBean(wfId, fi.getName(), g.getStatus(), fi.getId(), fi.getCreationTime().getTime(), lastAction.getDate(), lastAction.getAction());
                    toRet.add(toAdd);
                    continue;
                }
                log.debug("workflow report belongs to " + storedServerName + " SKIPPING");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return toRet;
    }

    public ArrayList<WfTemplateBean> getAllTemplates() {
        ArrayList<WfTemplateBean> templates = new ArrayList<WfTemplateBean>();
        for (WfGraphDetails g : this.store.getAllWorkflowTemplates()) {
            templates.add(new WfTemplateBean(g.getId(), g.getName(), g.getAuthor(), "unknown date"));
        }
        return templates;
    }

    public WfTemplate getWfTemplate(String id) {
        WfGraphDetails g = this.store.getWfTemplateById(id);
        WfGraph graph = (WfGraph)this.xstream.fromXML(g.getGraph());
        return new WfTemplate(g.getId(), g.getName(), g.getAuthor(), g.getDateCreated(), graph);
    }

    public WfTemplate getWfReport(String id) {
        WfTemplate toRet = null;
        try {
            WfGraphDetails fi = this.store.getWorkflowById(id);
            WfGraph graph = (WfGraph)this.xstream.fromXML(fi.getGraph());
            toRet = new WfTemplate(fi.getId(), fi.getName(), fi.getAuthor(), fi.getDateCreated(), graph);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return toRet;
    }

    public ArrayList<WfRoleDetails> getRoleDetails() {
        log.debug("Getting Workflow Roles from DB");
        ArrayList<WfRoleDetails> toReturn = new ArrayList<WfRoleDetails>();
        for (WfRole r : this.store.getAllRoles()) {
            toReturn.add(new WfRoleDetails(r.getRoleid(), r.getRolename()));
        }
        return toReturn;
    }

    public ArrayList<UserBean> getVREUsers() {
        ArrayList<UserBean> toRet = new ArrayList<UserBean>();
        if (this.isTesting) {
            toRet.add(new UserBean("1", "Giorgino De Benedicits", "giorgino.degazz"));
            toRet.add(new UserBean("2", "Birmbo Barumbo", "birimbo.barumbo"));
            toRet.add(new UserBean("3", "Pippo De Pippa", "pippo.pippa"));
            toRet.add(new UserBean("4", "Foo De Fie", "foo.fie"));
        } else {
            LiferayUserManager um = new LiferayUserManager();
            try {
                List users = um.listUsersByGroup("" + this.getASLSession().getGroupId());
                for (UserModel user : users) {
                    toRet.add(new UserBean(user.getUserId(), user.getFullname(), user.getScreenName()));
                }
            }
            catch (UserManagementSystemException e) {
                e.printStackTrace();
            }
            catch (GroupRetrievalFault e) {
                e.printStackTrace();
            }
            catch (UserRetrievalFault e) {
                e.printStackTrace();
            }
        }
        return toRet;
    }

    public Boolean saveWorkflow(String selectedReportid, String selectedReportName, WfGraph toSave, HashMap<String, List<UserBean>> rolesAndUsersToCreate) {
        boolean overAllResult;
        Step[] steps = toSave.getSteps();
        for (int i = 0; i < steps.length; ++i) {
            Step curStep = steps[i];
            ArrayList fwactions = toSave.getForwardActions(curStep);
            for (ForwardAction fa : fwactions) {
                HashMap<WfRole, HashMap> toAdd = new HashMap<WfRole, HashMap>();
                ArrayList roles = fa.getRoles();
                for (WfRole wfRole : roles) {
                    toAdd.put(wfRole, this.getUsernamesGivenRole(wfRole, rolesAndUsersToCreate));
                }
                fa.setActions(toAdd);
            }
        }
        log.info("Attempting to Save Workflow Report ..." + selectedReportName);
        String wfXML = this.xstream.toXML((Object)toSave);
        log.info("Saving WfReport into DB ...");
        String firstStatus = steps[0].getLabel();
        String workflowid = this.store.addWorkflowReport(selectedReportid, selectedReportName, firstStatus, this.getASLSession().getUsername(), wfXML);
        log.info("Saving into DB SUCCESSFUL, returning id: " + workflowid);
        String serverName = this.getThreadLocalRequest().getServerName();
        boolean resultHL = this.saveToWorkspace(selectedReportName, serverName, workflowid, firstStatus, wfXML, 1);
        List createdRoles = this.commitChangesInLiferayDB(selectedReportid, selectedReportName, workflowid, rolesAndUsersToCreate);
        Report toWrite = this.getReportFromHL(selectedReportid);
        String filename = workflowid + ".zip";
        System.out.println("Attempting Writing in DocLib name: " + filename);
        Step start = toSave.getSteps()[0];
        boolean resultLRDoc = false;
        try {
            DocLibraryUtil.writeFileIntoDocLibrary((ASLSession)this.getASLSession(), (List)createdRoles, (Step)start, (String)filename, (byte[])this.getBytesFromInputStream(toWrite.getData()));
            resultLRDoc = true;
        }
        catch (InternalErrorException e) {
            resultLRDoc = false;
            e.printStackTrace();
        }
        boolean bl = overAllResult = resultHL && resultLRDoc && createdRoles.size() > 0;
        if (overAllResult) {
            AccessLogger log = AccessLogger.getAccessLogger();
            CreatedWorkflowReportLogEntry logEntry = new CreatedWorkflowReportLogEntry(selectedReportName, workflowid, steps.length);
            log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
            for (WfRole wfRole : start.getPermissions().keySet()) {
                for (String rolename : rolesAndUsersToCreate.keySet()) {
                    if (!rolename.equals(wfRole.getRolename())) continue;
                    List<UserBean> usersForThisRole = rolesAndUsersToCreate.get(rolename);
                    for (UserBean userBean : usersForThisRole) {
                        String user2Notify = userBean.getScreenName();
                        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.getASLSession(), "org.gcube.portlets.user.workflowdocuments.server.WfDocumentsLibraryServiceImpl");
                        nm.notifyDocumentWorkflowFirstStepRequest(user2Notify, workflowid, selectedReportName, rolename);
                    }
                }
            }
        }
        return overAllResult;
    }

    private Report getReportFromHL(String reportid) {
        Workspace root = null;
        Report report = null;
        try {
            FolderItem fItem;
            root = this.getWorkspaceArea();
            WorkspaceItem item = root.getItem(reportid);
            if (item.getType() == WorkspaceItemType.FOLDER_ITEM && (fItem = (FolderItem)item).getFolderItemType() == FolderItemType.REPORT) {
                report = (Report)fItem;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return report;
    }

    private List<Role> commitChangesInLiferayDB(String selectedReportid, String selectedReportName, String workflowid, HashMap<String, List<UserBean>> rolesAndUsersToCreate) {
        ArrayList<Role> createdRoles = new ArrayList<Role>();
        LiferayUserManager uman = new LiferayUserManager();
        try {
            for (String rolename : rolesAndUsersToCreate.keySet()) {
                Role created = this.createRole(rolename, selectedReportName, workflowid);
                createdRoles.add(created);
                log.debug("Created Role: " + created.getName() + " with id " + created.getRoleId());
                Set users = this.getUsernamesGivenRole(new WfRole("", rolename, ""), rolesAndUsersToCreate).keySet();
                for (UserInfo userInfo : users) {
                    UserModel user = uman.getUserByScreenName(userInfo.getUserName());
                    long[] roleids = new long[]{created.getRoleId()};
                    RoleLocalServiceUtil.addUserRoles((long)Long.parseLong(user.getUserId()), (long[])roleids);
                    log.debug("Assigned role: " + created.getName() + " to " + user.getFullname());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return createdRoles;
    }

    private Role createRole(String roleName, String workflowname, String workflowid) {
        try {
            Company company = OrganizationsUtil.getCompany();
            String roletoAdd = roleName + "_" + workflowid;
            return RoleLocalServiceUtil.addRole((long)0L, (long)company.getCompanyId(), (String)roletoAdd, null, (String)(roleName + " of " + workflowname + " (" + workflowid + ")"), (int)3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap<UserInfo, Boolean> getUsernamesGivenRole(WfRole role, HashMap<String, List<UserBean>> rolesAndUsersToCreate) {
        HashMap<UserInfo, Boolean> toReturn = new HashMap<UserInfo, Boolean>();
        for (String roleName : rolesAndUsersToCreate.keySet()) {
            if (roleName.compareTo(role.getRolename()) != 0) continue;
            List<UserBean> users = rolesAndUsersToCreate.get(roleName);
            for (UserBean user : users) {
                toReturn.put(new UserInfo(user.getId(), user.getDysplayName(), user.getScreenName(), ""), false);
            }
        }
        return toReturn;
    }

    private boolean saveToWorkspace(String name, String description, String workflowid, String status, String data, int i) {
        Workspace root = null;
        try {
            root = this.getWorkspaceArea();
            root.createWorkflowReport(name, description, workflowid, status, data, root.getRoot().getId());
            return true;
        }
        catch (ItemAlreadyExistException ex) {
            ++i;
            if (name.charAt(name.length() - 2) == ' ') {
                name = name.substring(0, name.length() - 2);
            }
            name = name + " " + i;
            this.saveToWorkspace(name, description, workflowid, status, data, i);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected Workspace getWorkspaceArea() throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException {
        return HomeLibrary.getUserWorkspace((String)this.getASLSession().getUsername());
    }

    byte[] getBytesFromInputStream(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    public ArrayList<ActionLogBean> fetchActionsByWorkflowId(String workflowid) {
        ArrayList<ActionLogBean> actions = new ArrayList<ActionLogBean>();
        ArrayList storeActions = this.store.getLogActionsByWorkflowId(workflowid);
        for (LogAction logAction : storeActions) {
            actions.add(new ActionLogBean(logAction.getWorkflowid(), logAction.getDate(), this.getDisplaynameByUsername(logAction.getAuthor()), logAction.getActiontype()));
        }
        return actions;
    }

    private String getDisplaynameByUsername(String username) {
        try {
            ArrayList users = this.getVREUsers();
            for (UserBean userBean : users) {
                if (userBean.getScreenName().compareTo(username) != 0) continue;
                return userBean.getScreenName();
            }
        }
        catch (Exception e) {
            return username;
        }
        return username;
    }

    public Boolean deleteWorkflowDocument(WfDocumentBean docBean) {
        String workflowid = docBean.getId();
        boolean del1 = DocLibraryUtil.deleteFileFromDocLibrary((ASLSession)this.getASLSession(), (String)workflowid);
        boolean del2 = this.deleteFromHL(docBean.getHomeLibraryId());
        WfGraphDetails fi = this.store.getWorkflowById(workflowid);
        WfGraph graph = (WfGraph)this.xstream.fromXML(fi.getGraph());
        boolean del3 = this.deleteRolesFromLR(graph, workflowid);
        boolean del4 = this.store.deleteWorkflowReport(workflowid);
        AccessLogger log = AccessLogger.getAccessLogger();
        DeletedWorkflowLogEntry logEntry = new DeletedWorkflowLogEntry(docBean.getName(), docBean.getId(), docBean.getStatus());
        log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
        return del1 && del2 && del3 && del4;
    }

    private boolean deleteRolesFromLR(WfGraph g, String workflowid) {
        try {
            List rolesToDelete = this.getWorkflowLiferayRoles(workflowid, g);
            for (Role role : rolesToDelete) {
                RoleLocalServiceUtil.deleteRole((Role)role);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<Role> getWorkflowLiferayRoles(String workflowid, WfGraph graph) throws Exception {
        ArrayList<Role> toReturn = new ArrayList<Role>();
        ArrayList worflowRoles = this.getAllRolesFromWorkflow(graph);
        List allRoles = RoleLocalServiceUtil.getRoles((int)0, (int)RoleLocalServiceUtil.getRolesCount());
        for (WfRole wfRole : worflowRoles) {
            String roleToFind = wfRole.getRolename() + "_" + workflowid;
            for (Role role : allRoles) {
                if (!role.getName().equals(roleToFind)) continue;
                toReturn.add(role);
            }
        }
        return toReturn;
    }

    private ArrayList<WfRole> getAllRolesFromWorkflow(WfGraph graph) {
        ArrayList<WfRole> toRet = new ArrayList<WfRole>();
        Step[] steps = graph.getSteps();
        for (int i = 0; i < steps.length; ++i) {
            Step curStep = steps[i];
            if (curStep.getPermissions() == null) continue;
            for (WfRole role : curStep.getPermissions().keySet()) {
                boolean found = false;
                for (WfRole retRole : toRet) {
                    if (!retRole.getRoleid().equals(role.getRoleid())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRet.add(role);
            }
        }
        return toRet;
    }

    private boolean deleteFromHL(String idToDelete) {
        try {
            Workspace wp = this.getWorkspaceArea();
            wp.removeItem(idToDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

