/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.client.application.controller;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.portlets.user.accountingdashboard.client.application.dialog.error.ErrorPresenter;
import org.gcube.portlets.user.accountingdashboard.client.application.dialog.info.InfoPresenter;
import org.gcube.portlets.user.accountingdashboard.client.application.dialog.monitor.MonitorPresenter;
import org.gcube.portlets.user.accountingdashboard.client.application.event.HelloEvent;
import org.gcube.portlets.user.accountingdashboard.client.rpc.AccountingDashboardServiceAsync;
import org.gcube.portlets.user.accountingdashboard.shared.data.RequestReportData;

public class Controller {
    private static Logger logger = Logger.getLogger("");
    private EventBus eventBus;
    private AccountingDashboardServiceAsync service;
    private MonitorPresenter monitorPresenter;
    private ErrorPresenter errorPresenter;
    private InfoPresenter infoPresenter;

    @Inject
    Controller(@Named(value="ControllerEventBus") EventBus eventBus, AccountingDashboardServiceAsync service, MonitorPresenter monitorPresenter, ErrorPresenter errorPresenter, InfoPresenter infoPresenter) {
        this.eventBus = eventBus;
        this.service = service;
        this.monitorPresenter = monitorPresenter;
        this.errorPresenter = errorPresenter;
        this.infoPresenter = infoPresenter;
    }

    public void fireEvent(GwtEvent<?> event) {
        this.eventBus.fireEventFromSource(event, (Object)this);
    }

    public final <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        return this.eventBus.addHandler(type, handler);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void errorShow(String error) {
        logger.log(Level.FINE, "Error show: " + error);
        this.errorPresenter.errorMessage(error);
    }

    public void infoShow(String info) {
        logger.log(Level.FINE, "Info show: " + info);
        this.infoPresenter.infoMessage(info);
    }

    public void hello() {
        this.eventBus.fireEvent((GwtEvent)new HelloEvent());
    }

    public void callHello() {
        this.service.hello((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getTree() {
        this.service.getScopeData((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getReport(RequestReportData requestReportData) {
        this.monitorPresenter.enable(true);
        this.service.getReport(requestReportData, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ ErrorPresenter access$100(Controller x0) {
        return x0.errorPresenter;
    }

    static /* synthetic */ EventBus access$200(Controller x0) {
        return x0.eventBus;
    }

    static /* synthetic */ MonitorPresenter access$300(Controller x0) {
        return x0.monitorPresenter;
    }
}

