/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.server;

import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.portlets.user.dataminermanagertester.server.SessionUtil;
import org.gcube.portlets.user.dataminermanagertester.server.task.TaskRequest;
import org.gcube.portlets.user.dataminermanagertester.server.task.TaskWrapper;
import org.gcube.portlets.user.dataminermanagertester.server.testbatch.TesterCaller;
import org.gcube.portlets.user.dataminermanagertester.shared.exception.ServiceException;
import org.gcube.portlets.user.dataminermanagertester.shared.result.BatchTestResult;
import org.gcube.portlets.user.dataminermanagertester.shared.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMinerTesterCallable
implements Callable<TaskStatus> {
    private static Logger logger = LoggerFactory.getLogger(DataMinerTesterCallable.class);
    private TaskRequest taskRequest;

    public DataMinerTesterCallable(TaskRequest taskRequest) {
        this.taskRequest = taskRequest;
        logger.debug("DataMinerTesterCallable: " + taskRequest);
    }

    @Override
    public TaskStatus call() throws Exception {
        try {
            HttpSession httpSession = this.taskRequest.getHttpSession();
            if (httpSession == null) {
                logger.error("Error retrieving HttpSession in DataMinerTesterCallable: is null");
                return TaskStatus.ERROR;
            }
            logger.debug("Set SecurityToken: " + this.taskRequest.getServiceCredentials().getToken());
            SecurityTokenProvider.instance.set(this.taskRequest.getServiceCredentials().getToken());
            logger.debug("Set ScopeProvider: " + this.taskRequest.getServiceCredentials().getScope());
            ScopeProvider.instance.set(this.taskRequest.getServiceCredentials().getScope());
            TesterCaller testerCaller = new TesterCaller();
            BatchTestResult result = null;
            try {
                result = testerCaller.runTest(this.taskRequest);
            }
            catch (ServiceException e) {
                TaskWrapper taskWrapper = new TaskWrapper(this.taskRequest.getOperationId(), TaskStatus.ERROR, e.getLocalizedMessage());
                HashMap<String, TaskWrapper> taskWrapperMap = SessionUtil.getTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials());
                if (taskWrapperMap == null) {
                    taskWrapperMap = new HashMap<String, TaskWrapper>();
                    SessionUtil.setTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials(), taskWrapperMap);
                }
                taskWrapperMap.put(taskWrapper.getOperationId(), taskWrapper);
                return TaskStatus.ERROR;
            }
            TaskWrapper taskWrapper = new TaskWrapper(this.taskRequest.getOperationId(), TaskStatus.COMPLETED, result);
            HashMap<String, TaskWrapper> taskWrapperMap = SessionUtil.getTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials());
            if (taskWrapperMap == null) {
                taskWrapperMap = new HashMap<String, TaskWrapper>();
                SessionUtil.setTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials(), taskWrapperMap);
            }
            taskWrapperMap.put(taskWrapper.getOperationId(), taskWrapper);
            return TaskStatus.COMPLETED;
        }
        catch (Throwable e) {
            logger.error("DataMinerTesterDaemon Execute(): " + e.getLocalizedMessage(), e);
            return TaskStatus.ERROR;
        }
    }
}

