/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.TextField;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.FileParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.ItemDescription;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.FileFld;
import org.gcube.portlets.user.dataminermanager.client.rpc.DataMinerPortletServiceAsync;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;
import org.gcube.portlets.user.dataminermanager.client.workspace.DownloadWidget;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.event.SelectVariableEvent;
import org.gcube.portlets.widgets.netcdfbasicwidgets.client.widgets.NetCDFPreviewDialog;
import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSelectNotification;
import org.gcube.portlets.widgets.wsexplorer.client.select.WorkspaceExplorerSelectDialog;
import org.gcube.portlets.widgets.wsexplorer.shared.Item;

public class FileFld
extends AbstractFld {
    private VerticalLayoutContainer vp;
    private WorkspaceExplorerSelectDialog wselectDialog;
    private TextButton selectButton;
    private TextButton selectButton2;
    private TextButton cancelButton;
    private ItemDescription selectedFileItem = null;
    private FileParameter fileParameter;
    private SimpleContainer fieldContainer;
    private HBoxLayoutContainer horiz;
    private TextButton downloadButton;
    private TextButton netcdfButton;

    public FileFld(Parameter parameter) {
        super(parameter);
        HtmlLayoutContainer descr;
        this.fileParameter = (FileParameter)parameter;
        SimpleContainer tabContainer = new SimpleContainer();
        this.vp = new VerticalLayoutContainer();
        this.init();
        tabContainer.add((Widget)this.vp, new MarginData(new Margins(0)));
        this.fieldContainer = new SimpleContainer();
        this.horiz = new HBoxLayoutContainer();
        this.horiz.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        this.horiz.setEnableOverflow(false);
        if (this.fileParameter.getDescription() == null || this.fileParameter.getDescription().isEmpty()) {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'></p>");
            descr.addStyleName("workflow-fieldDescription");
        } else if (this.fileParameter.isNetcdf()) {
            String des = this.fileParameter.getDescription().replaceFirst("\\[NETCDF\\]", "");
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + des + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        } else {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + this.fileParameter.getDescription() + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        }
        this.horiz.add((IsWidget)tabContainer, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.horiz.add((IsWidget)descr, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.fieldContainer.add((Widget)this.horiz);
        this.showNoSelectionField();
    }

    private void init() {
        this.wselectDialog = new WorkspaceExplorerSelectDialog("Select File", false);
        1 handler = new /* Unavailable Anonymous Inner Class!! */;
        this.wselectDialog.addWorkspaceExplorerSelectNotificationListener((WorkspaceExplorerSelectNotification.WorskpaceExplorerSelectNotificationListener)handler);
        this.wselectDialog.setZIndex(XDOM.getTopZIndex());
        this.selectButton = new TextButton("Select File");
        this.selectButton.setIcon(DataMinerManager.resources.folderExplore());
        this.selectButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectButton.setToolTip("Select File");
        this.selectButton2 = new TextButton("");
        this.selectButton2.setIcon(DataMinerManager.resources.folderExplore());
        this.selectButton2.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectButton2.setToolTip("Select Another File");
        this.cancelButton = new TextButton("");
        this.cancelButton.setIcon(DataMinerManager.resources.cancel());
        this.cancelButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadButton = new TextButton("");
        this.downloadButton.setIcon(DataMinerManager.resources.download());
        this.downloadButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.netcdfButton = new TextButton("");
        this.netcdfButton.setIcon(DataMinerManager.resources.netcdf());
        this.netcdfButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveFileInformation(Item item) {
        Log.debug((String)("Retrieved: " + item));
        ItemDescription itemDescription = new ItemDescription(item.getId(), item.getName(), item.getOwner(), item.getPath(), item.getType().name());
        DataMinerPortletServiceAsync.INSTANCE.getPublicLink(itemDescription, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void downloadFile() {
        if (this.selectedFileItem != null) {
            DownloadWidget downloadWidget = new DownloadWidget();
            downloadWidget.download(this.selectedFileItem.getId());
        } else {
            UtilsGXT3.info((String)"Attention", (String)"Select a file!");
        }
    }

    private void showNetCDFFile() {
        if (this.selectedFileItem != null) {
            GWT.log((String)"NetcdfBasicWidgetsManager");
            8 handler = new /* Unavailable Anonymous Inner Class!! */;
            NetCDFPreviewDialog netcdfDialog = new NetCDFPreviewDialog(this.selectedFileItem.getPublicLink());
            netcdfDialog.addSelectVariableEventHandler((SelectVariableEvent.SelectVariableEventHandler)handler);
            netcdfDialog.setZIndex(XDOM.getTopZIndex());
        }
    }

    private void showNoSelectionField() {
        this.vp.clear();
        this.vp.add((Widget)this.selectButton);
        this.vp.forceLayout();
        this.fieldContainer.forceLayout();
    }

    private void showFieldWithSelection() {
        String fileName = this.selectedFileItem.getName();
        if (fileName == null || fileName.isEmpty()) {
            fileName = "NoName";
        }
        TextField tableDescription = new TextField();
        tableDescription.setValue((Object)fileName);
        tableDescription.setReadOnly(true);
        HBoxLayoutContainer h = new HBoxLayoutContainer();
        h.add((IsWidget)tableDescription, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        h.add((IsWidget)this.selectButton2, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        h.add((IsWidget)this.downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        if (this.fileParameter.isNetcdf()) {
            h.add((IsWidget)this.netcdfButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        }
        h.add((IsWidget)this.cancelButton, new BoxLayoutContainer.BoxLayoutData(new Margins()));
        this.vp.clear();
        this.vp.add((Widget)h);
        this.vp.forceLayout();
        this.fieldContainer.forceLayout();
    }

    public boolean isValid() {
        return this.selectedFileItem != null;
    }

    public Widget getWidget() {
        return this.fieldContainer;
    }

    public String getValue() {
        return this.selectedFileItem == null ? null : this.selectedFileItem.getPublicLink();
    }

    static /* synthetic */ void access$000(FileFld x0, Item x1) {
        x0.retrieveFileInformation(x1);
    }

    static /* synthetic */ WorkspaceExplorerSelectDialog access$100(FileFld x0) {
        return x0.wselectDialog;
    }

    static /* synthetic */ ItemDescription access$202(FileFld x0, ItemDescription x1) {
        x0.selectedFileItem = x1;
        return x0.selectedFileItem;
    }

    static /* synthetic */ void access$300(FileFld x0) {
        x0.showNoSelectionField();
    }

    static /* synthetic */ void access$400(FileFld x0) {
        x0.downloadFile();
    }

    static /* synthetic */ void access$500(FileFld x0) {
        x0.showNetCDFFile();
    }

    static /* synthetic */ ItemDescription access$200(FileFld x0) {
        return x0.selectedFileItem;
    }

    static /* synthetic */ void access$600(FileFld x0) {
        x0.showFieldWithSelection();
    }
}

