/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.computations;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.TextArea;
import com.sencha.gxt.widget.core.client.form.TextField;
import java.util.LinkedHashMap;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValue;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueFile;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueFileList;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueImage;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationValueFileListPanel;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationValueFilePanel;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationValueImagePanel;
import org.gcube.portlets.user.dataminermanager.client.computations.ComputationsViewerPanel;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;

public class ComputationsViewerPanel
extends FramedPanel {
    private VerticalLayoutContainer v;
    private ComputationData computationData;

    public ComputationsViewerPanel(ComputationData computationData) {
        Log.debug((String)"ComputationsViewerPanel");
        this.computationData = computationData;
        Log.debug((String)("ComputationData: " + computationData));
        this.init();
        this.create();
    }

    private void init() {
        this.setItemId("ComputationsViewerPanel");
        this.forceLayoutOnResize = true;
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setBodyStyle("backgroundColor:white;");
        this.setHeaderVisible(false);
        this.setResize(true);
        this.setHeadingText("Computations Viewer");
        this.setBodyStyle("backgroundColor:white;");
    }

    private void create() {
        try {
            this.v = new VerticalLayoutContainer();
            this.v.setScrollMode(ScrollSupport.ScrollMode.AUTO);
            this.add((Widget)this.v);
            this.createView();
            this.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)("Error creating ComputationsViewerPanel: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void createView() {
        if (this.computationData == null) {
            Log.error((String)"ComputationData is null!");
            UtilsGXT3.alert((String)"Error", (String)"No information on computation is retrieved!");
            return;
        }
        if (this.computationData.getComputationId() == null || this.computationData.getComputationId().getId() == null || this.computationData.getComputationId().getId().isEmpty()) {
            Log.error((String)("Error in computationId: " + this.computationData));
            UtilsGXT3.alert((String)"Error", (String)"No information on computation id is retrieved!");
            return;
        }
        SimpleContainer sectionTitle = new SimpleContainer();
        HtmlLayoutContainer title = new HtmlLayoutContainer("<center>Computation Report of <b>" + this.computationData.getComputationId().getId() + "</b></center>");
        sectionTitle.add((Widget)title, new MarginData());
        sectionTitle.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
        this.v.add((IsWidget)sectionTitle, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
        if (this.computationData.getOutputParameters() != null && !this.computationData.getOutputParameters().isEmpty()) {
            FieldSet outputFieldSet = this.outputView();
            this.v.add((IsWidget)outputFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
        }
        if (this.computationData.getInputParameters() != null && !this.computationData.getInputParameters().isEmpty()) {
            FieldSet inputFieldSet = this.inputView();
            this.v.add((IsWidget)inputFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
        }
        FieldSet detailsFieldSet = this.detailsView();
        this.v.add((IsWidget)detailsFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
        FieldSet operatorFieldSet = this.operatorView();
        this.v.add((IsWidget)operatorFieldSet, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(10)));
    }

    private FieldSet operatorView() {
        try {
            VerticalLayoutContainer operatorVBox = new VerticalLayoutContainer();
            TextField operatorNameField = new TextField();
            operatorNameField.setValue((Object)this.computationData.getComputationId().getOperatorName());
            operatorNameField.setReadOnly(true);
            FieldLabel operatorNameLabel = new FieldLabel((IsWidget)operatorNameField, "Operator Name");
            operatorNameLabel.setLabelWidth(200);
            operatorNameLabel.setLabelWordWrap(true);
            operatorVBox.add((IsWidget)operatorNameLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            TextArea operatorDescriptionField = new TextArea();
            operatorDescriptionField.setHeight(40);
            operatorDescriptionField.setValue((Object)this.computationData.getOperatorDescription());
            operatorDescriptionField.setReadOnly(true);
            FieldLabel operatorDescriptionLabel = new FieldLabel((IsWidget)operatorDescriptionField, "Operator Description");
            operatorDescriptionLabel.setLabelWidth(200);
            operatorDescriptionLabel.setLabelWordWrap(true);
            operatorDescriptionLabel.setHeight(65);
            operatorVBox.add((IsWidget)operatorDescriptionLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 5, 0, 5)));
            FieldSet operatorFieldSet = new FieldSet();
            operatorFieldSet.setHeadingText("Operator Details");
            operatorFieldSet.setCollapsible(true);
            operatorFieldSet.setHeight(130);
            operatorFieldSet.add((Widget)operatorVBox);
            operatorFieldSet.getElement().getStyle().setMarginBottom(120.0, Style.Unit.PX);
            operatorFieldSet.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
            return operatorFieldSet;
        }
        catch (Throwable e) {
            Log.error((String)("Error in ComputationsViewerPanel in operator: " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private FieldSet detailsView() {
        try {
            VerticalLayoutContainer detailsVBox = new VerticalLayoutContainer();
            TextField startDateField = new TextField();
            startDateField.setValue((Object)this.computationData.getStartDate());
            startDateField.setReadOnly(true);
            FieldLabel startDateLabel = new FieldLabel((IsWidget)startDateField, "Start Date");
            startDateLabel.setLabelWidth(200);
            startDateLabel.setLabelWordWrap(true);
            detailsVBox.add((IsWidget)startDateLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            TextField endDateField = new TextField();
            endDateField.setValue((Object)this.computationData.getEndDate());
            endDateField.setReadOnly(true);
            FieldLabel endDateLabel = new FieldLabel((IsWidget)endDateField, "End Date");
            endDateLabel.setLabelWidth(200);
            endDateLabel.setLabelWordWrap(true);
            detailsVBox.add((IsWidget)endDateLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            TextField statusField = new TextField();
            statusField.setValue((Object)this.computationData.getStatus());
            statusField.setReadOnly(true);
            FieldLabel statusLabel = new FieldLabel((IsWidget)statusField, "Status");
            statusLabel.setLabelWidth(200);
            statusLabel.setLabelWordWrap(true);
            detailsVBox.add((IsWidget)statusLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            TextField vreField = new TextField();
            vreField.setValue((Object)this.computationData.getVre());
            vreField.setReadOnly(true);
            FieldLabel vreLabel = new FieldLabel((IsWidget)vreField, "VRE");
            vreLabel.setLabelWidth(200);
            vreLabel.setLabelWordWrap(true);
            detailsVBox.add((IsWidget)vreLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            FieldSet detailsFieldSet = new FieldSet();
            detailsFieldSet.setHeadingText("Computation Details");
            detailsFieldSet.setCollapsible(true);
            detailsFieldSet.add((Widget)detailsVBox);
            detailsFieldSet.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
            return detailsFieldSet;
        }
        catch (Throwable e) {
            Log.error((String)("Error in ComputationsViewerPanel in details: " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private FieldSet inputView() {
        try {
            VerticalLayoutContainer inputVBox = new VerticalLayoutContainer();
            LinkedHashMap input = this.computationData.getInputParameters();
            for (String key : input.keySet()) {
                ComputationValue computationValue = (ComputationValue)input.get(key);
                Log.debug((String)("Input: [key=" + key + ", ComputationValue=" + computationValue + "]"));
                FieldLabel fieldLabel = null;
                if (computationValue == null) {
                    TextField textField = new TextField();
                    textField.setReadOnly(true);
                    fieldLabel = new FieldLabel((IsWidget)textField, key);
                    fieldLabel.setLabelWidth(200);
                    fieldLabel.setLabelWordWrap(true);
                    inputVBox.add((IsWidget)fieldLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
                    continue;
                }
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$data$computations$ComputationValueType[computationValue.getType().ordinal()]) {
                    case 1: {
                        ComputationValueFile computationValueFile = (ComputationValueFile)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueFilePanel(computationValueFile);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                        break;
                    }
                    case 2: {
                        ComputationValueImage computationValueImage = (ComputationValueImage)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueImagePanel(computationValueImage);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                        break;
                    }
                    case 3: {
                        ComputationValueFileList computationValueFileList = (ComputationValueFileList)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueFileListPanel(computationValueFileList);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                        break;
                    }
                    default: {
                        TextField textField = new TextField();
                        textField.setValue((Object)computationValue.getValue());
                        textField.setReadOnly(true);
                        fieldLabel = new FieldLabel((IsWidget)textField, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                    }
                }
                inputVBox.add((IsWidget)fieldLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            }
            FieldSet inputFieldSet = new FieldSet();
            inputFieldSet.setHeadingText("Input Parameters");
            inputFieldSet.setCollapsible(true);
            inputFieldSet.add((Widget)inputVBox);
            inputFieldSet.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
            return inputFieldSet;
        }
        catch (Throwable e) {
            Log.error((String)("Error in ComputationsViewerPanel creating input view: " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private FieldSet outputView() {
        try {
            VerticalLayoutContainer outputVBox = new VerticalLayoutContainer();
            LinkedHashMap output = this.computationData.getOutputParameters();
            for (String key : output.keySet()) {
                ComputationValue computationValue = (ComputationValue)output.get(key);
                Log.debug((String)("Output: [key=" + key + ", ComputationValue=" + computationValue + "]"));
                FieldLabel fieldLabel = null;
                if (computationValue == null) {
                    TextField textField = new TextField();
                    textField.setReadOnly(true);
                    fieldLabel = new FieldLabel((IsWidget)textField, key);
                    fieldLabel.setLabelWidth(200);
                    fieldLabel.setLabelWordWrap(true);
                    outputVBox.add((IsWidget)fieldLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
                    continue;
                }
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$data$computations$ComputationValueType[computationValue.getType().ordinal()]) {
                    case 1: {
                        ComputationValueFile computationValueFile = (ComputationValueFile)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueFilePanel(computationValueFile);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                        break;
                    }
                    case 2: {
                        ComputationValueImage computationValueImage = (ComputationValueImage)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueImagePanel(computationValueImage);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                        break;
                    }
                    case 3: {
                        ComputationValueFileList computationValueFileList = (ComputationValueFileList)computationValue;
                        ComputationValueFilePanel simpleContainer = new ComputationValueFileListPanel(computationValueFileList);
                        fieldLabel = new FieldLabel((IsWidget)simpleContainer, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                    }
                    default: {
                        TextField textField = new TextField();
                        textField.setValue((Object)computationValue.getValue());
                        textField.setReadOnly(true);
                        fieldLabel = new FieldLabel((IsWidget)textField, key);
                        fieldLabel.setLabelWidth(200);
                        fieldLabel.setLabelWordWrap(true);
                    }
                }
                outputVBox.add((IsWidget)fieldLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0, 4, 0, 4)));
            }
            FieldSet outputFieldSet = new FieldSet();
            outputFieldSet.setHeadingText("Output Result");
            outputFieldSet.setCollapsible(true);
            outputFieldSet.add((Widget)outputVBox);
            outputFieldSet.getElement().getStyle().setMarginRight(20.0, Style.Unit.PX);
            return outputFieldSet;
        }
        catch (Throwable e) {
            Log.error((String)("Error in ComputationsViewerPanel creating output view: " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

