/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.info.Info;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.custom.progress.GreenProgressBar;
import org.gcube.portlets.user.dataminermanager.client.custom.progress.OrangeProgressBar;
import org.gcube.portlets.user.dataminermanager.client.custom.progress.RedProgressBar;
import org.gcube.portlets.user.dataminermanager.client.events.CancelComputationExecutionRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.experiments.ComputationOutputPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.ComputationStatusPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.EquivalentRequestDialog;
import org.gcube.portlets.user.dataminermanager.client.experiments.LinkToMonitorComputationDialog;
import org.gcube.portlets.user.dataminermanager.client.util.ElementsHighlights;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;

public class ComputationStatusPanel
extends SimpleContainer {
    private ProgressBar progressBar;
    private ComputationId computationId;
    private String operatorName;
    private boolean terminated = false;
    private ComputationTimer timer = new ComputationTimer(this, null);
    private TextButton cancelComputationBtn;
    private VerticalLayoutContainer vert;

    public ComputationStatusPanel(String operatorName) {
        this.operatorName = operatorName;
        this.init();
        this.create();
    }

    private void init() {
        this.setStylePrimaryName("computationStatusPanel");
    }

    private void create() {
        this.vert = new VerticalLayoutContainer();
        HtmlLayoutContainer title = new HtmlLayoutContainer("<div class='computationStatusTitle'><p>Computation of <b>" + this.operatorName + "</b></p></div>");
        this.vert.add((IsWidget)title, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.add((Widget)this.vert);
        this.forceLayout();
    }

    public void computationStarted(ComputationId computationId) {
        this.computationId = computationId;
        this.vert.add((Widget)new HtmlLayoutContainer("<p><span style='margin-right:165px;'>Id:</span> " + computationId.getId() + "</p>"));
        TextButton equivalentRequestBtn = new TextButton();
        equivalentRequestBtn.setText("Show");
        equivalentRequestBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        FieldLabel equivalentRequestLabel = new FieldLabel((IsWidget)equivalentRequestBtn, "WPS Request");
        equivalentRequestLabel.setLabelWidth(180);
        this.vert.add((IsWidget)equivalentRequestLabel, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        TextButton monitorComputationBtn = new TextButton();
        monitorComputationBtn.setText("Show");
        monitorComputationBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        FieldLabel monitorComputationLabel = new FieldLabel((IsWidget)monitorComputationBtn, "Link to monitor the computation");
        monitorComputationLabel.setLabelWidth(180);
        this.vert.add((IsWidget)monitorComputationLabel, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.progressBar = new ProgressBar();
        this.progressBar.updateProgress(0.0, "Starting...");
        this.vert.add((IsWidget)this.progressBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
        this.cancelComputationBtn = new TextButton("Cancel");
        this.cancelComputationBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelComputationBtn.getElement().getStyle().setMarginBottom(36.0, Style.Unit.PX);
        this.vert.add((IsWidget)this.cancelComputationBtn, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        this.forceLayout();
        this.timer.scheduleRepeating(5000);
    }

    private void showEquivalentRequestDialog() {
        EquivalentRequestDialog equivalentRequestDialog = new EquivalentRequestDialog(this.computationId);
        equivalentRequestDialog.show();
    }

    private void showLinkToMonitorComputationDialog() {
        LinkToMonitorComputationDialog linkToMonitorComputDialogDialog = new LinkToMonitorComputationDialog(this.computationId);
        linkToMonitorComputDialogDialog.show();
    }

    private void cancelComputation() {
        CancelComputationExecutionRequestEvent event = new CancelComputationExecutionRequestEvent(this.computationId);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void computationTerminated(ComputationId computationId, ComputationStatus computationStatus) {
        Log.debug((String)"Computation Terminated");
        Log.debug((String)("Computation Status:" + computationStatus));
        if (!this.terminated) {
            this.terminated = true;
            this.cancelComputationBtn.setVisible(false);
            if (computationStatus.isComplete()) {
                Log.debug((String)"Computation is Complete");
                Info.display((String)"Terminated", (String)("The computation " + computationId.getId() + " of " + computationId.getOperatorName() + " is terminated correctly."));
                int index = this.vert.getWidgetIndex((Widget)this.progressBar);
                this.vert.remove(index);
                this.progressBar = new GreenProgressBar();
                this.progressBar.updateProgress(1.0, "Computation Complete");
                this.vert.insert((IsWidget)this.progressBar, index, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
                this.showComputationCompletedOutput();
            } else if (computationStatus.isFailed()) {
                String errorMessage;
                Log.debug((String)"Computation is Failed");
                if (computationStatus.getError() == null) {
                    errorMessage = new String("Computation Failed!");
                } else {
                    errorMessage = computationStatus.getError().getLocalizedMessage();
                    ElementsHighlights el = new ElementsHighlights();
                    errorMessage = el.createLinkFromText(errorMessage);
                }
                Info.display((String)"Failed", (String)("The computation " + computationId.getId() + " of " + computationId.getOperatorName() + " is failed."));
                UtilsGXT3.alert((String)"Failed", (String)("The computation " + computationId.getId() + " of " + computationId.getOperatorName() + " has failed.</br>" + errorMessage));
                int index = this.vert.getWidgetIndex((Widget)this.progressBar);
                this.vert.remove(index);
                this.progressBar = new RedProgressBar();
                this.progressBar.updateProgress(1.0, "Computation Failed");
                this.progressBar.getElement().getStyle().setMarginBottom(36.0, Style.Unit.PX);
                this.vert.insert((IsWidget)this.progressBar, index, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
            } else if (computationStatus.isCancelled()) {
                Log.debug((String)"Computation Cancelled");
                String errorMessage = new String("Computation Cancelled!");
                Info.display((String)"Info", (String)("The computation " + computationId.getId() + " of " + computationId.getOperatorName() + " has been cancelled."));
                UtilsGXT3.info((String)"Info", (String)("The computation " + computationId.getId() + " of " + computationId.getOperatorName() + " has been cancelled.</br>" + errorMessage));
                int index = this.vert.getWidgetIndex((Widget)this.progressBar);
                this.vert.remove(index);
                this.progressBar = new OrangeProgressBar();
                this.progressBar.updateProgress(1.0, "Computation Cancelled");
                this.progressBar.getElement().getStyle().setMarginBottom(36.0, Style.Unit.PX);
                this.vert.insert((IsWidget)this.progressBar, index, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
            }
        }
        this.forceLayout();
    }

    private void showComputationCompletedOutput() {
        HtmlLayoutContainer computationEndMessage = new HtmlLayoutContainer("<p>The computation <b>" + this.computationId.getOperatorName() + "</b> finished.</p>");
        this.vert.add((IsWidget)computationEndMessage, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        ComputationOutputPanel computationOutputPanel = new ComputationOutputPanel(this.computationId);
        computationOutputPanel.getElement().getStyle().setMarginBottom(36.0, Style.Unit.PX);
        this.vert.add((IsWidget)computationOutputPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
    }

    private void updateStatus(ComputationStatus computationStatus) {
        Log.debug((String)("Conputation Status Panel ::Update Status " + computationStatus));
        if (computationStatus.getStatus().compareTo((Enum)ComputationStatus.Status.ACCEPTED) == 0) {
            this.progressBar.updateText("Accepted...");
        } else {
            double percentage = computationStatus.getPercentage();
            if (percentage == 0.0) {
                this.progressBar.updateText("Running, 0% Complete");
            } else {
                this.progressBar.updateProgress(percentage / 100.0, "Running, " + percentage + "% Complete");
            }
        }
        this.forceLayout();
    }

    public void stopTimer() {
        try {
            this.timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vert.clear();
    }

    static /* synthetic */ void access$100(ComputationStatusPanel x0) {
        x0.showEquivalentRequestDialog();
    }

    static /* synthetic */ void access$200(ComputationStatusPanel x0) {
        x0.showLinkToMonitorComputationDialog();
    }

    static /* synthetic */ TextButton access$300(ComputationStatusPanel x0) {
        return x0.cancelComputationBtn;
    }

    static /* synthetic */ void access$400(ComputationStatusPanel x0) {
        x0.cancelComputation();
    }

    static /* synthetic */ ComputationId access$500(ComputationStatusPanel x0) {
        return x0.computationId;
    }

    static /* synthetic */ ProgressBar access$600(ComputationStatusPanel x0) {
        return x0.progressBar;
    }

    static /* synthetic */ VerticalLayoutContainer access$700(ComputationStatusPanel x0) {
        return x0.vert;
    }

    static /* synthetic */ ProgressBar access$602(ComputationStatusPanel x0, ProgressBar x1) {
        x0.progressBar = x1;
        return x0.progressBar;
    }

    static /* synthetic */ void access$800(ComputationStatusPanel x0, ComputationId x1, ComputationStatus x2) {
        x0.computationTerminated(x1, x2);
    }

    static /* synthetic */ void access$900(ComputationStatusPanel x0, ComputationStatus x1) {
        x0.updateStatus(x1);
    }
}

