/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import java.util.Map;

import org.gcube.portlets.user.gcubegisviewer.client.event.HasSaveHandlers;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveEvent;
import org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler;
import org.gcube.portlets.widgets.lighttree.client.ItemType;
import org.gcube.portlets.widgets.lighttree.client.event.DataLoadEvent;
import org.gcube.portlets.widgets.lighttree.client.event.DataLoadHandler;
import org.gcube.portlets.widgets.lighttree.client.event.PopupEvent;
import org.gcube.portlets.widgets.lighttree.client.event.PopupHandler;
import org.gcube.portlets.widgets.lighttree.client.save.WorkspaceLightTreeSavePopup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class GCubeGisViewerSaveHandler implements GisViewerSaveHandler {
	
	protected static GCubeGisViewerServiceAsync service = (GCubeGisViewerServiceAsync)GWT.create(GCubeGisViewerService.class);		
	protected HasSaveHandlers hasSaveHandlers;
	
	/**
	 * @param hasSaveHandlers the hasSaveHandlers to set
	 */
	public void setHasSaveHandlers(HasSaveHandlers hasSaveHandlers) {
		this.hasSaveHandlers = hasSaveHandlers;
	}

	@Override
	public void saveLayerImage(String name, String contentType, String url) {
		GWT.log("saveLayerImage name: "+name+" contentType: "+contentType+" url: "+url);
		String message = "Select where to save the Layer item";		
		openWorkspaceLightTree(message, name, contentType, url);		
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler#saveMapImage(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[])
	 */
	@Override
	public void saveMapImage(String name, final String outputFormat, final String bbox,
			final String width, final String height, final String[] geoservers, final String[] layers,
			final String[] styles, final String[] opacities, final String[] cqlfilters,
			final String[] gsrefs) {
		GWT.log("saveMapImage name: "+name+" contentType: "+outputFormat);

		try {
			WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Map Image", true, name);

			popup.addStyleName("z_index_1200");
			popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

			popup.center();

			popup.addPopupHandler(new PopupHandler() {
				
				public void onPopup(PopupEvent event) {
					if (!event.isCanceled()){
						org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
						final String name = event.getName();
						SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
						
						service.saveMapImageItem(name, outputFormat, bbox, width, height, geoservers, layers, styles, opacities, cqlfilters, gsrefs, item.getId(), new AsyncCallback<Void>() {

							@Override
							public void onSuccess(Void result) {
								SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
							}

							@Override
							public void onFailure(Throwable caught) {
								SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
							}

						});						
					}
				}

			});
			popup.addDataLoadHandler(new DataLoadHandler() {
				
				@Override
				public void onDataLoad(DataLoadEvent event) {
					if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
				}
				
				
			});
			popup.show();	

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	@Override
	public void saveMapImage(String name, String contentType, String url) {
		GWT.log("saveMapImage name: "+name+" contentType: "+contentType+" url: "+url);
		String message = "Select where to save the Map Image";		
		openWorkspaceLightTree(message, name, contentType, url);		
	}

	 */

	/**
	 * @param message
	 * @param name
	 * @param contentType
	 * @param url
	 */
	private void openWorkspaceLightTree(String message, String name,
			final String contentType, final String url) {
		WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Layer item", true, name);

		popup.addStyleName("z_index_1200");
		popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

		popup.center();

		popup.addPopupHandler(new PopupHandler() {
			
			public void onPopup(PopupEvent event) {
				if (!event.isCanceled()){
					org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
					final String name = event.getName();
					SaveEvent.fireSave(hasSaveHandlers, name, contentType);
					service.saveLayerItem(name, contentType, url, item.getId(), new AsyncCallback<Void>() {
						
						@Override
						public void onSuccess(Void result) {
							SaveEvent.fireSaveSuccess(hasSaveHandlers, name, contentType);
						}
						
						@Override
						public void onFailure(Throwable caught) {
							SaveEvent.fireSaveFailure(hasSaveHandlers, name, contentType, caught);
						}
					});	
					
				}
			}

		});
		popup.addDataLoadHandler(new DataLoadHandler() {
			
			@Override
			public void onDataLoad(DataLoadEvent event) {
				if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
			}
			
			
		});
		popup.show();	
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler#saveMapImage(java.lang.String, java.lang.String, java.util.Map)
	 */
	@Override
	public void saveMapImage(String fileName, final String outputFormat,
			final Map<String, String> parameters) {
		
		GWT.log("saveMapImage name: "+fileName+" contentType: "+outputFormat);

		try {
			WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Map Image", true, fileName);

			popup.addStyleName("z_index_1200");
			popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

			popup.center();

			popup.addPopupHandler(new PopupHandler() {
				
				public void onPopup(PopupEvent event) {
					if (!event.isCanceled()){
						org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
						final String name = event.getName();
						SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
						
						service.saveMapImageItem(name, outputFormat, parameters, item.getId(), new AsyncCallback<Void>() {

							@Override
							public void onSuccess(Void result) {
								SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
							}

							@Override
							public void onFailure(Throwable caught) {
								SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
							}

						});						
					}
				}

			});
			popup.addDataLoadHandler(new DataLoadHandler() {
				
				@Override
				public void onDataLoad(DataLoadEvent event) {
					if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
				}
				
				
			});
			popup.show();	

		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
