/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import java.util.Map;

import org.gcube.portlets.user.gcubegisviewer.client.event.HasSaveHandlers;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveEvent;
import org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler;
import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener;
import org.gcube.portlets.widgets.wsexplorer.client.save.WorkspaceExplorerSaveDialog;
import org.gcube.portlets.widgets.wsexplorer.shared.Item;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 * updated by Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 */
public class GCubeGisViewerSaveHandler implements GisViewerSaveHandler {
	
	protected static GCubeGisViewerServiceAsync service = (GCubeGisViewerServiceAsync)GWT.create(GCubeGisViewerService.class);		
	protected HasSaveHandlers hasSaveHandlers;
	
	/**
	 * @param hasSaveHandlers the hasSaveHandlers to set
	 */
	public void setHasSaveHandlers(HasSaveHandlers hasSaveHandlers) {
		this.hasSaveHandlers = hasSaveHandlers;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler#saveLayerImage(java.lang.String, java.lang.String, java.lang.String, int)
	 */
	@Override
	public void saveLayerImage(String name, String contentType, String url, int zIndex) {
		GWT.log("saveLayerImage name: "+name+" contentType: "+contentType+" url: "+url);
		String message = "Select where to save the Layer item";		
		openWorkspaceExplorer(message, name, contentType, url, zIndex);		
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler#saveMapImage(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[], java.lang.String[])
	 */
	@Override
	public void saveMapImage(String name, final String outputFormat, final String bbox,
			final String width, final String height, final String[] geoservers, final String[] layers,
			final String[] styles, final String[] opacities, final String[] cqlfilters,
			final String[] gsrefs, int zIndex) {
		
		GWT.log("saveMapImage name: "+name+" contentType: "+outputFormat);

		final WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Select where to save the Map Image", name, true);
		 
		WorskpaceExplorerSaveNotificationListener listener = new WorskpaceExplorerSaveNotificationListener(){
	 
			@Override
			public void onSaving(Item parent, String fileName) {
				final String name = fileName;
				SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
				
				service.saveMapImageItem(name, outputFormat, bbox, width, height, geoservers, layers, styles, opacities, cqlfilters, gsrefs, parent.getId(), new AsyncCallback<Void>() {

					@Override
					public void onSuccess(Void result) {
						SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
					}

					@Override
					public void onFailure(Throwable caught) {
						SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
					}

				});				
				navigator.hide();
			}
	 
			@Override
			public void onAborted() {
				GWT.log("onAborted");
			}
	 
			@Override
			public void onFailed(Throwable throwable) {
				GWT.log("Workspace Explorer loading failure", throwable);
			}
		};
	 
		navigator.addWorkspaceExplorerSaveNotificationListener(listener);
		navigator.setZIndex(zIndex);
		navigator.show();
		
		/*
		try {
			WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Map Image", true, name);

			popup.addStyleName("z_index_1200");
			popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

			popup.center();

			popup.addPopupHandler(new PopupHandler() {
				
				public void onPopup(PopupEvent event) {
					if (!event.isCanceled()){
						org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
						final String name = event.getName();
						SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
						
						service.saveMapImageItem(name, outputFormat, bbox, width, height, geoservers, layers, styles, opacities, cqlfilters, gsrefs, item.getId(), new AsyncCallback<Void>() {

							@Override
							public void onSuccess(Void result) {
								SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
							}

							@Override
							public void onFailure(Throwable caught) {
								SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
							}

						});						
					}
				}

			});
			popup.addDataLoadHandler(new DataLoadHandler() {
				
				@Override
				public void onDataLoad(DataLoadEvent event) {
					if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
				}
				
				
			});
			popup.show();	

		} catch (Exception e) {
			e.printStackTrace();
		}*/
	}

	/*
	@Override
	public void saveMapImage(String name, String contentType, String url) {
		GWT.log("saveMapImage name: "+name+" contentType: "+contentType+" url: "+url);
		String message = "Select where to save the Map Image";		
		openWorkspaceLightTree(message, name, contentType, url);		
	}

	 */

	
	/**
	 * Open workspace explorer.
	 *
	 * @param message the message
	 * @param name the name
	 * @param contentType the content type
	 * @param url the url
	 * @param zIndex the z index
	 */
	private void openWorkspaceExplorer(String message, String name, final String contentType, final String url, int zIndex) {
		
		final WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog(message, name, true);
		 
		WorskpaceExplorerSaveNotificationListener listener = new WorskpaceExplorerSaveNotificationListener(){
	 
			@Override
			public void onSaving(Item parent, String fileName) {
				final String name = fileName;
				SaveEvent.fireSave(hasSaveHandlers, name, contentType);
				service.saveLayerItem(name, contentType, url, parent.getId(), new AsyncCallback<Void>() {
					
					@Override
					public void onSuccess(Void result) {
						SaveEvent.fireSaveSuccess(hasSaveHandlers, name, contentType);
					}
					
					@Override
					public void onFailure(Throwable caught) {
						SaveEvent.fireSaveFailure(hasSaveHandlers, name, contentType, caught);
					}
				});	
				navigator.hide();
			}
	 
			@Override
			public void onAborted() {
				GWT.log("onAborted");
			}
	 
			@Override
			public void onFailed(Throwable throwable) {
				GWT.log("Workspace Explorer loading failure", throwable);
			}
		};
	 
		navigator.addWorkspaceExplorerSaveNotificationListener(listener);
		navigator.setZIndex(zIndex);
		navigator.show();
	        
		
		/*
		WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Layer item", true, name);

//		popup.addStyleName("z_index_1200");
		popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);
		popup.center();

		popup.addPopupHandler(new PopupHandler() {
			
			public void onPopup(PopupEvent event) {
				if (!event.isCanceled()){
					org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
					final String name = event.getName();
					SaveEvent.fireSave(hasSaveHandlers, name, contentType);
					service.saveLayerItem(name, contentType, url, item.getId(), new AsyncCallback<Void>() {
						
						@Override
						public void onSuccess(Void result) {
							SaveEvent.fireSaveSuccess(hasSaveHandlers, name, contentType);
						}
						
						@Override
						public void onFailure(Throwable caught) {
							SaveEvent.fireSaveFailure(hasSaveHandlers, name, contentType, caught);
						}
					});	
					
				}
			}

		});
		popup.addDataLoadHandler(new DataLoadHandler() {
			
			@Override
			public void onDataLoad(DataLoadEvent event) {
				if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
			}
			
			
		});
		popup.show();	
		
		*/
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler#saveMapImage(java.lang.String, java.lang.String, java.util.Map)
	 */
	@Override
	public void saveMapImage(String fileName, final String outputFormat,
			final Map<String, String> parameters, int zIndex) {
		
		GWT.log("saveMapImage name: "+fileName+" contentType: "+outputFormat);

		final WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Select where to save the Map Image", fileName, true);
		 
		WorskpaceExplorerSaveNotificationListener listener = new WorskpaceExplorerSaveNotificationListener(){
	 
			@Override
			public void onSaving(Item parent, String fileName) {
				final String name = fileName;
				SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
				
				service.saveMapImageItem(name, outputFormat, parameters, parent.getId(), new AsyncCallback<Void>() {

					@Override
					public void onSuccess(Void result) {
						SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
					}

					@Override
					public void onFailure(Throwable caught) {
						SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
					}

				});				
				navigator.hide();
			}
	 
			@Override
			public void onAborted() {
				GWT.log("onAborted");
			}
	 
			@Override
			public void onFailed(Throwable throwable) {
				GWT.log("Workspace Explorer loading failure", throwable);
			}
		};
	 
		navigator.addWorkspaceExplorerSaveNotificationListener(listener);
		navigator.setZIndex(zIndex);
		navigator.show();
		
		/*
		try {
			WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Map Image", true, fileName);

			popup.addStyleName("z_index_1200");
			popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

			popup.center();

			popup.addPopupHandler(new PopupHandler() {
				
				public void onPopup(PopupEvent event) {
					if (!event.isCanceled()){
						org.gcube.portlets.widgets.lighttree.client.Item item = event.getSelectedItem();
						final String name = event.getName();
						SaveEvent.fireSave(hasSaveHandlers, name, outputFormat);
						
						service.saveMapImageItem(name, outputFormat, parameters, item.getId(), new AsyncCallback<Void>() {

							@Override
							public void onSuccess(Void result) {
								SaveEvent.fireSaveSuccess(hasSaveHandlers, name, outputFormat);
							}

							@Override
							public void onFailure(Throwable caught) {
								SaveEvent.fireSaveFailure(hasSaveHandlers, name, outputFormat, caught);
							}

						});						
					}
				}

			});
			popup.addDataLoadHandler(new DataLoadHandler() {
				
				@Override
				public void onDataLoad(DataLoadEvent event) {
					if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
				}
				
				
			});
			popup.show();	

		} catch (Exception e) {
			e.printStackTrace();
		}
		*/
	}

}
