package org.gcube.portlets.user.gisviewer.server;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MapGenerator extends HttpServlet {

	private static final long serialVersionUID = 1L;


	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {

		// get parameters

		String[] strRis = getOutputExtension(request);
		String outputFormat = strRis[0];
		String outputExtension = strRis[1];
			
		String bbox = request.getParameter("bbox");
		String width = request.getParameter("width");
		String height = request.getParameter("height");
		
		String[] geoservers = splitParameter(request, "geoservers");
		String[] layers = splitParameter(request, "layers");
		String[] styles = splitParameter(request, "styles");
		String[] opacities = splitParameter(request, "opacities");
		String[] cqlfilters = splitParameter(request, "cqlfilters");
		String[] gsrefs = splitParameter(request, "gsrefs");			

//			testUrlImages(urls, opacities, response);

		BufferedImage imgRis;
		try {
			imgRis = MapGeneratorUtils.createMapImage(outputFormat, bbox, width, height, geoservers, layers, styles, opacities, cqlfilters, gsrefs);
		
			//--Send the image data to response  
			response.setContentType(outputFormat);  
			OutputStream outputStream = response.getOutputStream();  
			ImageIO.write(imgRis, outputExtension, outputStream);  
			outputStream.close();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}


	private String[] splitParameter(HttpServletRequest request, String paramName) {
		String paramValue = request.getParameter(paramName);
		String[] result = paramValue.split(";");
		return result;
	}

	
	private String[] getOutputExtension(HttpServletRequest request) {
		Map<String, String> hash = new HashMap<String, String>();
		hash.put("image/jpeg", "jpeg");
		hash.put("image/gif", "gif");
		hash.put("image/png", "png");

		String ris[] = new String[2];		
		ris[0] = request.getParameter("outputFormat");
		if (ris[0]==null || hash.get(ris[0])==null) {		
			ris[0] = "image/jpeg";
			ris[1] = "jpeg";
		} else
			ris[1] = hash.get(ris[0]);
		return ris;
	}




//	private void showErrorImage(HttpServletResponse response, String message) {
//		try {
//			// get an error image
//			InputStream inputStremLogo = MapGenerator.class.getResourceAsStream(NAME_IMG_ERROR);
//			BufferedImage img = ImageIO.read(inputStremLogo);
//			// add an error message
//			Graphics g = img.getGraphics();
//			g.setColor(COLOR_BLACK);
//			g.setFont(FONT);
//			g.drawString(message, 55, img.getHeight()/2);
//
//			// send the image data to response  
//			response.setContentType("image/png");
//			OutputStream outputStream;
//			outputStream = response.getOutputStream();
//			ImageIO.write(img, "png", outputStream);  
//			outputStream.close();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}  
//	}

	@SuppressWarnings("unused")
	private void testUrlImages(String[] urls, String[] opacities, HttpServletResponse response) throws Exception {
		response.setContentType("text/html");
		PrintWriter out = response.getWriter();
		out.print("<html><body bgcolor='#FFFF00'><h1><center>TEST</center></h1>");

		int i=0;
		for (String lUrl : urls) {
			out.println(lUrl+"<br/><b>"+opacities[i++]+"</b><br/><img src='"+lUrl+"'/><br>");
		}

		out.println("</body></html>");
	}

	@SuppressWarnings("unused")
	private String decodeUrl(String url) {
		String url2 = url.toString();
		url2 = url2.replaceAll("%25", "%");
		url2 = url2.replaceAll("%26", "&");
		url2 = url2.replaceAll("%2C", ",");
		url2 = url2.replaceAll("%3B", ";");
		url2 = url2.replaceAll("%3A", ":");
		url2 = url2.replaceAll("%2F", "/");
		return url2;
	}


}