/**
 * 
 */
package org.gcube.portlets.user.gisviewer.server;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

import org.gcube.portlets.user.gisviewer.client.Constants;


/**
 * @author ceras
 *
 */
public class MapGeneratorUtils {

	private static final String NAME_IMG_LOGO = "resources/D4ScienceInfrastructureLogo.png";
	private static final int MAX_THREADS = 5;
	private static final String NAME_IMG_ERROR = "resources/error.png";
	private static final Color COLOR_BLACK = new Color(10, 10, 10);
	private static Font FONT = new Font("Monospaced", Font.BOLD, 12);
	private static final Color BGCOLOR = new Color(255, 255, 255);

	/**
	 * @param layers 
	 * @return
	 * @throws IOException 
	 */
	/*
	String outputFormat = strRis[0];
	String outputExtension = strRis[1];
			
	String bbox = request.getParameter("bbox");
	String width = request.getParameter("width");
	String height = request.getParameter("height");
			
	String[] geoservers = splitParameter(request, "geoservers");
	String[] layers = splitParameter(request, "layers");
	String[] styles = splitParameter(request, "styles");
	String[] opacities = splitParameter(request, "opacities");
	String[] cqlfilters = splitParameter(request, "cqlfilters");
	String[] gsrefs = splitParameter(request, "gsrefs");			
	 
	 */
	
	public static BufferedImage createMapImage(
			String outputFormat, 
			String bbox, 
			String width, 
			String height, 
			String[] geoservers, 
			String[] layers, 
			String[] styles, 
			String[] opacities, 
			String[] cqlfilters, 
			String[] gsrefs) throws IOException {
		
		System.out.println("GEOSERVERS");
		for (String g : geoservers)
			System.out.println(g);
		
		try {
			// instantiate thread pool (one thread for each layer map request)
			ExecutorService executor = Executors.newFixedThreadPool(MAX_THREADS);
			List<ImageLoaderThread> threads = new ArrayList<ImageLoaderThread>();
	
			// start each thread
			for (int i=0; i<layers.length; i++) {
				int gsref = Integer.parseInt(gsrefs[i]);	
				String geoserver = geoservers[gsref];
				String layer = layers[i];
				String style = styles[i];
				String cqlfilter = cqlfilters[i];
				
				String url = geoserver + ""
					+ (geoserver.contains("?") ? "&" : "?")
					+ "SERVICE=WMS&version=1.1.0"
					+ "&REQUEST=GetMap"
					+ "&LAYERS=" + layer
					+ "&STYLES=" + ((style==null || style.equals("null")) ? "" : style)
					+ "&BBOX=" + bbox
					+ "&WIDTH=" + width
					+ "&HEIGHT=" + height
					+ "&SRS=EPSG:4326"
					+ (cqlfilter.equals("null") ? "" : "&CQL_FILTER="+cqlfilter)
					+ "&FORMAT=image/png"
					+ "&TRANSPARENT=true";
				
				ImageLoaderThread thread = (i==0) ? new ImageLoaderThread(url, opacities[0]) : new ImageLoaderThread(url);
				executor.execute(thread);
				threads.add(thread);
			}
	
			// waiting for threads termination
			executor.shutdown();
			if (!executor.awaitTermination(60, TimeUnit.SECONDS)) {
				return errorImage("Error: Timeout expired.");
			}
			
			// for each thread, merge obtained images each other 
			int i=0;
			BufferedImage imgRis=null;			
			for (ImageLoaderThread thread: threads) {
				BufferedImage img = thread.getImg();
				if (img!=null) {
					// initializing first image
					if (i==0)
						imgRis = img;
					else
						mergeImage(imgRis, img, Float.valueOf(opacities[i]), 0, 0);
					i++;
				}
			}
	
			// overlay logo image
			InputStream inputStremLogo = MapGeneratorUtils.class.getResourceAsStream(NAME_IMG_LOGO);
			BufferedImage imgLogo = ImageIO.read(inputStremLogo);
			int x=imgRis.getWidth()-imgLogo.getWidth()-4, y=imgRis.getHeight()-imgLogo.getHeight()-4;
			mergeImage(imgRis, imgLogo, 0.8f, x, y);
			
			return imgRis;
			
		}  catch (MalformedURLException e) {
			return errorImage(e.toString());
		} catch (IOException e) {
			return errorImage("Error: I/O Exception.");
		} catch (Exception e) {
			e.printStackTrace();
			return errorImage("Error: Invalid parameters.");
		}
	}
	
	/**
	 * @param string
	 * @return
	 * @throws IOException 
	 */
	private static BufferedImage errorImage(String message) throws IOException {
		// get an error image
		InputStream inputStremLogo = MapGeneratorUtils.class.getResourceAsStream(NAME_IMG_ERROR);
		BufferedImage img = ImageIO.read(inputStremLogo);
		// add an error message
		Graphics g = img.getGraphics();
		g.setColor(COLOR_BLACK);
		g.setFont(FONT);
		g.drawString(message, 55, img.getHeight()/2);

		return img;
	}

	private static void mergeImage(BufferedImage imgRis, BufferedImage img, float opacity, int x, int y) {
		if (img.getHeight() > imgRis.getHeight()
				|| img.getWidth() > img.getWidth()) {
			JOptionPane.showMessageDialog(null,
					"Foreground Image Is Bigger In One or Both Dimensions"
							+ "\nCannot proceed with overlay."
							+ "\n\n Please use smaller Image for foreground");
			return;
		}

		// Create a Graphics  from the background image
		Graphics2D g = imgRis.createGraphics();
		// Set Antialias Rendering
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		// draw background image (at location (0,0))
		g.drawImage(imgRis, 0, 0, null); 

		// create a rescale filter op that makes the image opaque.
		float[] scales = { 1f, 1f, 1f, opacity };
		float[] offsets = new float[4];
		RescaleOp rop = new RescaleOp(scales, offsets, null);

		// draw the image, applying the opacity filter
		g.drawImage(img, rop, x, y);

		g.dispose();
	}

	
	private static class ImageLoaderThread implements Runnable{
		private String url;
		private boolean first=false;
		private float opacity;
		private BufferedImage img=null;

		public ImageLoaderThread(String url, String opacity){
			this.url = url;
			this.first = true;
			this.opacity = Float.valueOf(opacity);
		}

		public ImageLoaderThread(String url){
			this.url = url;
		}

		public void run(){
			Constants.log(" loading image at url: "+url+(first? " (first)" : ""));
			try {
				img = ImageIO.read(new URL(url));
				if (first) {
					BufferedImage imgRis = getBackgroundImage(img);
					mergeImage(imgRis, img, opacity, 0, 0);
					img = imgRis;
				}
			} catch (Exception e) {
				e.printStackTrace();
				img=null;
			}
		}

		public BufferedImage getImg() {
			return img;
		}
	}

	private static BufferedImage getBackgroundImage(BufferedImage referImg) {
		int w = referImg.getWidth();
		int h = referImg.getHeight();

		BufferedImage backgroundImg = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		Graphics g = backgroundImg.getGraphics();
		g.setColor(BGCOLOR);
		g.fillRect(0, 0, w, h);
		g.dispose();

		return backgroundImg;
	}
	
	public static String getOutputExtension(String outputFormat) {
		Map<String, String> hash = new HashMap<String, String>();
		hash.put("image/jpeg", "jpeg");
		hash.put("image/gif", "gif");
		hash.put("image/png", "png");

		if (outputFormat==null || hash.get(outputFormat)==null)		
			return "jpeg";
		else
			return hash.get(outputFormat);
	}
	
}
