package org.gcube.portlets.user.gisviewer.server.datafeature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.gcube.portlets.user.gisviewer.client.commons.beans.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FeatureTypeParser {
	
	
	public static List<Property> getProperties(String geoserverURL,
			String layerName) {
		String wfsRequestURL = geoserverURL
			+ "/wfs?service=wfs&version=1.1.0&request=DescribeFeatureType&typeName="
			+ layerName;
		
//		System.out.println("wfsRequestURL "+wfsRequestURL);
		
		List<Property> properties = new ArrayList<Property>();
		
		try {

			// Now we parse the XML file with JAXP.
			// First of all we do need to load the document into DOM Document object.
			DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
			domFactory.setNamespaceAware(true); 
			DocumentBuilder builder = domFactory.newDocumentBuilder();
			Document doc = builder.parse(wfsRequestURL);
			
			// normalize text representation
            doc.getDocumentElement ().normalize ();

            // get all layer's properties 
			NodeList elements = doc.getElementsByTagName("xsd:element");
			
            for(int i=0; i<elements.getLength() ; i++){
                Node node = elements.item(i);
                if(node.getNodeType() == Node.ELEMENT_NODE) {
                	// get property name and property type
                    Element element = (Element)node;
                    
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    
                    if (name!=null && type!=null)
                    	properties.add(new Property(name, type));
                }
            }
            
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return properties;
	}
}
// http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver/wfs?service=wfs&version=1.1.0&request=DescribeFeatureType&typeName=aquamaps:depthmean