package org.gcube.portlets.user.gisviewer.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.portlets.user.gisviewer.client.commons.beans.GisViewerBaseLayerInterface;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.resources.Resources;

import com.extjs.gxt.ui.client.event.BoxComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.client.GWT;

public class GisViewer extends Window {
	
	public GisViewerPanel gg;
	private boolean first = true;
	public static Resources resources = GWT.create(Resources.class);
	public static GisViewerServiceAsync service = (GisViewerServiceAsync) GWT.create(GisViewerService.class);

	
	public GisViewer() {
		this(new GisViewerParameters());
	}

	public GisViewer(GisViewerParameters parameters) {
		super();
		this.setHeading(Constants.geoWindowTitle);
		this.setSize(Constants.geoWindowWidth, Constants.geoWindowHeight);
		this.setMinWidth(Constants.geoWindowMinWidth);
		this.setMinHeight(Constants.geoWindowMinHeight);
		this.setMaximizable(true);
		this.setLayout(new FitLayout());
		
		if (Constants.geoWindowShadow)
			this.setStyleAttribute("padding", "10px");
		
		gg = new GisViewerPanel(parameters);
		this.add(gg);
		
		this.addListener(Events.Move, new Listener<BoxComponentEvent>(){
			@Override
			public void handleEvent(BoxComponentEvent be) {
				if (gg!=null) {
					gg.updateOpenLayersSize();
				}
			}
		});
	}
	

//	public void addLayers(LayerConfiguration ... layersConfigurations) {
//		gg.addLayersByLayerConfigurations(layersConfigurations);
//	}
	
	/**
	 * Add base layer to Open Layer Map
	 * @param layers
	 */
	public void addBaseLayersToOLM(List<? extends GisViewerBaseLayerInterface> layers){
		gg.addBaseLayersToOLM(layers);
	}

	public void addLayersByNames(String ... layerNames) {
		gg.addLayersByLayerNames(Arrays.asList(layerNames));
	}

	public void addLayersByNames(List<String> layerNames) {
		gg.addLayersByLayerNames(layerNames);
	}

	public void addLayerByName(String layerName) {
		List<String> layerNames = new ArrayList<String>();
		layerNames.add(layerName);
		gg.addLayersByLayerNames(layerNames);
	}
	
	
	public void addLayersByLayerItems(List<LayerItem> layerItems) {
		gg.addLayersByLayerItems(layerItems);
	}

	public void addLayerByLayerItem(LayerItem layerItem) {
		gg.addLayerByLayerItem(layerItem);
	}
	
	public void addGroup(String groupName) {
		gg.addGroupByGroupName(groupName);
	}
	
	public void addLayersByLayerItemsToTop(List<LayerItem> layerItems) {
		gg.addLayersByLayerItemsToTop(layerItems);
	}

	public void addLayerByLayerItemToTop(LayerItem layerItem) {
		gg.addLayerByLayerItemToTop(layerItem);
	}

	public void removeAllLayers() {
		gg.removeAllLayers();
	}
	
	public void addLayerByWms(String title, String layerName, String url, boolean isBase, boolean displayInLayerSwitcher) {
		gg.addLayerByWms(title, layerName, url, isBase, displayInLayerSwitcher);
	}
	
	/* (non-Javadoc)
	 * @see com.extjs.gxt.ui.client.widget.Window#show()
	 */
	@Override
	public void show() {
		super.show();
		gg.showIntro();
	}

	public String getVersion() {
		return Constants.VERSION;
	}
}
