package org.gcube.portlets.user.gisviewer.client;

import org.gwtopenmaps.openlayers.client.LonLat;

// TODO: Auto-generated Javadoc
/**
 * The Class GisViewerParameters.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Sep 26, 2016
 */
public class GisViewerParameters {

	private String projection = null;
	private GisViewerSaveHandler gisViewerSaveHandler = null;
	private DataPanelOpenListener dataPanelOpenHandler = null;
	private boolean openDataPanelAtStart = Constants.geoWindowDataPanelOpenedAtStart;
	private boolean openLayerPanelAtStart = Constants.geoWindowLayerPanelOpenedAtStart;
	private LonLat centerMapTo = null; //new LonLat(12.45, 42.98); 
	private Integer initZoomTo = null;

	/**
	 * Instantiates a new gis viewer parameters.
	 */
	public GisViewerParameters(){
	}

	/**
	 * Instantiates a new gis viewer parameters.
	 *
	 * @param projection the projection
	 * @param gisViewerSaveHandler the gis viewer save handler
	 */
	public GisViewerParameters(String projection, GisViewerSaveHandler gisViewerSaveHandler) {
		this.projection = projection;
		this.gisViewerSaveHandler = gisViewerSaveHandler;
	}
	
	

	/**
	 * Instantiates a new gis viewer parameters.
	 *
	 * @param projection the projection
	 * @param gisViewerSaveHandler the gis viewer save handler
	 * @param dataPanelOpenHandler the data panel open handler
	 * @param openDataPanelAtStart the open data panel at start
	 * @param openLayerPanelAtStart the open layer panel at start
	 * @param centerMapTo the center map to
	 * @param initZoomTo the init zoom to
	 */
	public GisViewerParameters(String projection, GisViewerSaveHandler gisViewerSaveHandler,
			DataPanelOpenListener dataPanelOpenHandler, boolean openDataPanelAtStart, boolean openLayerPanelAtStart,
			LonLat centerMapTo, Integer initZoomTo) {
		super();
		this.projection = projection;
		this.gisViewerSaveHandler = gisViewerSaveHandler;
		this.dataPanelOpenHandler = dataPanelOpenHandler;
		this.openDataPanelAtStart = openDataPanelAtStart;
		this.openLayerPanelAtStart = openLayerPanelAtStart;
		this.centerMapTo = centerMapTo;
		this.initZoomTo = initZoomTo;
	}

	/**
	 * Checks if is open layer panel at start.
	 *
	 * @return true, if is open layer panel at start
	 */
	public boolean isOpenLayerPanelAtStart() {
		return openLayerPanelAtStart;
	}

	/**
	 * Sets the open layer panel at start.
	 *
	 * @param openLayerPanelAtStart the new open layer panel at start
	 */
	public void setOpenLayerPanelAtStart(boolean openLayerPanelAtStart) {
		this.openLayerPanelAtStart = openLayerPanelAtStart;
	}

	/**
	 * Sets the projection.
	 *
	 * @param projection the new projection
	 */
	public void setProjection(String projection) {
		this.projection = projection;
	}

	/**
	 * Gets the projection.
	 *
	 * @return the projection
	 */
	public String getProjection() {
		return projection;
	}

	/**
	 * Sets the gis viewer save handler.
	 *
	 * @param gisViewerSaveHandler the new gis viewer save handler
	 */
	public void setGisViewerSaveHandler(GisViewerSaveHandler gisViewerSaveHandler) {
		this.gisViewerSaveHandler = gisViewerSaveHandler;
	}

	/**
	 * Gets the gis viewer save handler.
	 *
	 * @return the gis viewer save handler
	 */
	public GisViewerSaveHandler getGisViewerSaveHandler() {
		return gisViewerSaveHandler;
	}

	/**
	 * Checks if is open data panel at start.
	 *
	 * @return the openDataPanelAtStart
	 */
	public boolean isOpenDataPanelAtStart() {
		return openDataPanelAtStart;
	}

	/**
	 * Sets the open data panel at start.
	 *
	 * @param openDataPanelAtStart the openDataPanelAtStart to set
	 */
	public void setOpenDataPanelAtStart(boolean openDataPanelAtStart) {
		this.openDataPanelAtStart = openDataPanelAtStart;
	}

	/**
	 * Sets the data panel open listener.
	 *
	 * @param dataPanelOpenHandler the dataPanelOpenHandler to set
	 */
	public void setDataPanelOpenListener(DataPanelOpenListener dataPanelOpenHandler) {
		this.dataPanelOpenHandler = dataPanelOpenHandler;
	}

	/**
	 * Gets the data panel open handler.
	 *
	 * @return the dataPanelOpenHandler
	 */
	public DataPanelOpenListener getDataPanelOpenHandler() {
		return dataPanelOpenHandler;
	}

	/**
	 * Gets the center map to.
	 *
	 * @return the center map to
	 */
	public LonLat getCenterMapTo() {
		return centerMapTo;
	}

	/**
	 * Sets the center map to.
	 *
	 * @param centerMapTo the new center map to
	 */
	public void setCenterMapTo(LonLat centerMapTo) {
		this.centerMapTo = centerMapTo;
	}

	/**
	 * Gets the inits the zoom to.
	 *
	 * @return the inits the zoom to
	 */
	public Integer getInitZoomTo() {
		return initZoomTo;
	}

	/**
	 * Sets the inits the zoom to.
	 *
	 * @param initZoomTo the new inits the zoom to
	 */
	public void setInitZoomTo(Integer initZoomTo) {
		this.initZoomTo = initZoomTo;
	}

	/**
	 * Sets the data panel open handler.
	 *
	 * @param dataPanelOpenHandler the new data panel open handler
	 */
	public void setDataPanelOpenHandler(DataPanelOpenListener dataPanelOpenHandler) {
		this.dataPanelOpenHandler = dataPanelOpenHandler;
	}
	
	
}
