/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRPDFFile
extends JCRFile {
    private static final String NUMBER_OF_PAGES = "hl:numberOfPages";
    private static final String VERSION = "hl:version";
    private static final String AUTHOR = "hl:author";
    private static final String TITLE = "hl:title";
    private static final String PRODUCER = "hl:producer";

    public JCRPDFFile(Node node) throws RepositoryException {
        super(node);
    }

    public JCRPDFFile(Node node, String mimeType, InputStream data) throws RepositoryException, IOException {
        super(node, new BufferedInputStream(data));
        InputStream dataPdf = node.getProperty("jcr:data").getBinary().getStream();
        HashMap<String, String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
        int numberOfPages = Integer.parseInt((String)infoPDF.get("hl-numberOfPages"));
        String version = (String)infoPDF.get("hl-version");
        String author = (String)infoPDF.get("Author");
        String title = (String)infoPDF.get("Title");
        String producer = (String)infoPDF.get("Producer");
        node.setProperty(NUMBER_OF_PAGES, (long)numberOfPages);
        node.setProperty(VERSION, version);
        node.setProperty(AUTHOR, author);
        node.setProperty(TITLE, title);
        node.setProperty(PRODUCER, producer);
        dataPdf.close();
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_PDF_FILE;
    }

    public int getNumberOfPages() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(NUMBER_OF_PAGES).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public String getVersion() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getProperty(VERSION).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public String getAuthor() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getProperty(AUTHOR).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public String getTitle() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getProperty(TITLE).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public String getProducer() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getProperty(PRODUCER).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }
}

