/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.home.JCRHome;

public class JCRHomeManager
implements HomeManager {
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private Map<String, JCRHome> userHomesLogged = new LinkedHashMap<String, JCRHome>();
    private HomeManagerFactory factory;
    private final File persistenceFoolder;
    private static Logger logger = Logger.getLogger((String)JCRHomeManager.class.getName());

    public JCRHomeManager(HomeManagerFactory factory, File persistenceFolder) {
        this.persistenceFoolder = persistenceFolder;
        this.factory = factory;
        this.createUsers();
    }

    private void createUsers() {
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.info((Object)("getUser portalLogin: " + portalLogin));
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace((Object)("existUser portalLogin: " + portalLogin));
        if (portalLogin == null) {
            logger.error((Object)"portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            logger.info((Object)("User " + portalLogin + " not found, creating a new one."));
            user = new JCRUser(UUID.randomUUID().toString(), portalLogin);
            logger.info((Object)("User created: " + user));
            this.users.put(portalLogin, user);
        }
        return user;
    }

    public Home getHome(User user) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.info((Object)("getHome user: " + user));
        if (this.userHomesLogged.containsKey(user.getPortalLogin())) {
            logger.debug((Object)" User is already logged");
            JCRHome home2 = this.userHomesLogged.get(user.getPortalLogin());
            return home2;
        }
        try {
            home = new JCRHome(this, (JCRUser)user, this.persistenceFoolder);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.userHomesLogged.put(user.getPortalLogin(), home);
        logger.trace((Object)"User loaded.");
        return home;
    }

    public Home getHome(String portalLogin) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.info((Object)("getHome portalLogin: " + portalLogin));
        User user = this.getUser(portalLogin);
        return this.getHome(user);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        this.userHomesLogged.remove(user.getPortalLogin());
    }
}

