/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.File;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;

public class JCRFile
implements File {
    private static final String MIME_TYPE = "jcr:mimeType";
    protected static final String DATA = "jcr:data";
    protected String nodeId;

    public JCRFile(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
    }

    public JCRFile(Node node, String mimeType, InputStream data) throws RepositoryException {
        Binary binary = node.getSession().getValueFactory().createBinary(data);
        node.setProperty(DATA, binary);
        node.setProperty(MIME_TYPE, mimeType);
    }

    public void save(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
    }

    public JCRFile(Node node, InputStream data) throws RepositoryException {
        this(node, MimeTypeUtil.getMimeType((InputStream)data), data);
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getName();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getMimeType() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getProperty(MIME_TYPE).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public InputStream getData() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            InputStream inputStream = node.getProperty(DATA).getBinary().getStream();
            return inputStream;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public long getLength() throws InternalErrorException {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            long l = node.getProperty(DATA).getBinary().getSize();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }
}

