/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentPartLink;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRDocumentMetadata;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentPartLink;

public class JCRDocument
extends JCRWorkspaceFolderItem
implements Document {
    private static final String METADATA = "hl:metadata";
    private static final String ANNOTATIONS = "hl:annotations";
    private static final String ALTERNATIVES = "hl:alternatives";
    private static final String PARENT_URI = "hl:parentUri";
    private static final String URI = "hl:uri";
    private static final String NAME = "hl:name";
    private static final String MIME_TYPE = "hl:mimeType";
    private static final String NT_ALTERNATIVE = "nthl:documentAlternativeLink";
    private static final String NT_PART = "nthl:documentPartLink";
    private static final String PARTS = "hl:parts";
    private static final String COLLECTION_NAME = "hl:collectionName";
    private static final String OID = "hl:oid";
    private static final String NT_CONTENT = "nthl:documentItemContent";
    private final String oid;
    private final Map<String, DocumentMetadata> metadata;
    private final Map<String, String> annotations;
    private List<DocumentAlternativeLink> alternatives;
    private List<DocumentPartLink> parts;
    private final String collectionName;
    protected JCRFile documentContent;

    public JCRDocument(JCRWorkspace workspace, Node node) throws RepositoryException {
        this(workspace, node, ContentType.GENERAL);
    }

    public JCRDocument(JCRWorkspace workspace, Node node, String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws RepositoryException, InternalErrorException {
        this(workspace, node, name, description, oid, mimeType, ContentType.GENERAL, documentData, metadata, annotations, collectionName);
    }

    protected JCRDocument(JCRWorkspace workspace, Node node, ContentType contentType) throws RepositoryException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.collectionName = contentNode.getProperty(COLLECTION_NAME).getString();
        this.oid = contentNode.getProperty(OID).getString();
        this.metadata = this.deserializeMetadata(contentNode);
        this.annotations = this.deserializeAnnotations(contentNode);
        this.documentContent = workspace.getGCUBEDocumentContent(node.getSession(), this.oid, contentType);
        LinkedList alternatives = this.getAlternativesFromNode(node);
        LinkedList parts = this.getPartsFromNode(node);
        this.alternatives = alternatives == null ? new LinkedList() : alternatives;
        this.parts = parts == null ? new LinkedList() : parts;
    }

    protected JCRDocument(JCRWorkspace workspace, Node node, String name, String description, String oid, String mimeType, ContentType contentType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        Validate.notNull((Object)oid, (String)"Oid must be not null");
        Validate.notNull((Object)mimeType, (String)"MimeType must be not null");
        Validate.notNull(metadata, (String)"Metadata must be not null");
        Validate.notNull(annotations, (String)"Annotations must be not null");
        Validate.notNull((Object)collectionName, (String)"CollectionName must be not null");
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        node.setProperty("hl:workspaceItemType", FolderItemType.DOCUMENT.toString());
        this.oid = oid;
        this.collectionName = collectionName;
        this.metadata = this.serializeMetadata(contentNode, metadata);
        this.annotations = this.serializeAnnotations(contentNode, annotations);
        contentNode.setProperty(OID, oid);
        contentNode.setProperty(COLLECTION_NAME, collectionName);
        try {
            this.documentContent = workspace.getGCUBEDocumentContent(node.getSession(), oid, contentType);
        }
        catch (RepositoryException e) {
            try {
                if (documentData == null) {
                    throw new InternalErrorException("Document content is not present end data stream is null");
                }
                this.documentContent = workspace.setGCUBEDocumentContent(node.getSession(), oid, documentData, mimeType, contentType);
            }
            catch (Exception e1) {
                throw new InternalErrorException("Document content save failed");
            }
        }
    }

    private Map<String, DocumentMetadata> serializeMetadata(Node contentNode, Map<String, String> metadata) throws RepositoryException {
        Node metadataNode = contentNode.getNode(METADATA);
        HashMap<String, DocumentMetadata> map = new HashMap<String, DocumentMetadata>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            metadataNode.setProperty(entry.getKey(), entry.getValue());
            map.put(entry.getKey(), new JCRDocumentMetadata(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private Map<String, DocumentMetadata> deserializeMetadata(Node contentNode) throws RepositoryException {
        Node metadataNode = contentNode.getNode(METADATA);
        HashMap<String, DocumentMetadata> map = new HashMap<String, DocumentMetadata>();
        PropertyIterator iterator = metadataNode.getProperties();
        while (iterator.hasNext()) {
            Property property = iterator.nextProperty();
            if (property.getName().startsWith("jcr:")) continue;
            JCRDocumentMetadata metadata = new JCRDocumentMetadata(property.getName(), property.getValue().getString());
            map.put(property.getName(), metadata);
        }
        return map;
    }

    private Map<String, String> serializeAnnotations(Node contentNode, Map<String, String> annotations) throws RepositoryException {
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        for (Map.Entry<String, String> entry : annotations.entrySet()) {
            annotationsNode.setProperty(entry.getKey(), entry.getValue());
        }
        return annotations;
    }

    private Map<String, String> deserializeAnnotations(Node contentNode) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        PropertyIterator iterator = annotationsNode.getProperties();
        while (iterator.hasNext()) {
            Property property = iterator.nextProperty();
            if (property.getName().startsWith("jcr:")) continue;
            map.put(property.getName(), property.getValue().getString());
        }
        return map;
    }

    public void setAlternatives(Session session, List<DocumentAlternativeLink> alternatives) {
        if (this.alternatives != null) {
            return;
        }
        this.alternatives = alternatives;
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            Node contentNode = itemNode.getNode("jcr:content");
            Node alternativesNode = contentNode.getNode(ALTERNATIVES);
            int index = 0;
            for (DocumentAlternativeLink documentAlternativeLink : alternatives) {
                Node alternative = alternativesNode.addNode("" + index, NT_ALTERNATIVE);
                logger.debug((Object)("\nINFOS ALTERNATIVES ---------------------------------- : " + documentAlternativeLink.getParentURI() + documentAlternativeLink.getURI() + documentAlternativeLink.getName() + documentAlternativeLink.getMimeType()));
                alternative.setProperty(PARENT_URI, documentAlternativeLink.getParentURI() == null ? "" : documentAlternativeLink.getParentURI());
                alternative.setProperty(URI, documentAlternativeLink.getURI() == null ? "" : documentAlternativeLink.getURI());
                alternative.setProperty(NAME, documentAlternativeLink.getName() == null ? "" : documentAlternativeLink.getName());
                alternative.setProperty(MIME_TYPE, documentAlternativeLink.getMimeType() == null ? "" : documentAlternativeLink.getMimeType());
                ++index;
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)"Set DocumentAlternativeLink failed", (Throwable)e);
        }
    }

    private List<DocumentAlternativeLink> getAlternativesFromNode(Node node) {
        LinkedList<DocumentAlternativeLink> list = new LinkedList<DocumentAlternativeLink>();
        try {
            Node contentNode = node.getNode("jcr:content");
            Node alternativesNode = contentNode.getNode(ALTERNATIVES);
            NodeIterator iterator = alternativesNode.getNodes();
            while (iterator.hasNext()) {
                Node alternative = iterator.nextNode();
                if (!alternative.getPrimaryNodeType().getName().equals(NT_ALTERNATIVE)) continue;
                logger.debug((Object)alternative.getPrimaryNodeType().getName());
                String parentURI = alternative.getProperty(PARENT_URI).getString();
                String uri = alternative.getProperty(URI).getString();
                String name = alternative.getProperty(NAME).getString();
                String mimeType = alternative.getProperty(MIME_TYPE).getString();
                JCRDocumentAlternativeLink documentAlternativeLink = new JCRDocumentAlternativeLink(parentURI, uri, name, mimeType);
                list.add(documentAlternativeLink);
            }
        }
        catch (RepositoryException e) {
            logger.debug((Object)"getDocumentAlternativeLink failed", (Throwable)e);
        }
        return list;
    }

    public void setParts(Session session, List<DocumentPartLink> parts) {
        this.parts = parts;
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            Node partsNode = contentNode.getNode(PARTS);
            int index = 0;
            for (DocumentPartLink documentPartLink : parts) {
                Node part = partsNode.addNode("" + index, NT_ALTERNATIVE);
                logger.debug((Object)("\nINFOS PARTS ------------------------------------ : " + documentPartLink.getParentURI() + documentPartLink.getURI() + documentPartLink.getName() + documentPartLink.getMimeType()));
                part.setProperty(PARENT_URI, documentPartLink.getParentURI() == null ? "" : documentPartLink.getParentURI());
                part.setProperty(URI, documentPartLink.getURI() == null ? "" : documentPartLink.getURI());
                part.setProperty(NAME, documentPartLink.getName() == null ? "" : documentPartLink.getName());
                part.setProperty(MIME_TYPE, documentPartLink.getMimeType() == null ? "" : documentPartLink.getMimeType());
                ++index;
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)"setPart failed", (Throwable)e);
        }
    }

    private List<DocumentPartLink> getPartsFromNode(Node node) {
        LinkedList<DocumentPartLink> list = new LinkedList<DocumentPartLink>();
        try {
            Node contentNode = node.getNode("jcr:content");
            Node partsNode = contentNode.getNode(PARTS);
            NodeIterator iterator = partsNode.getNodes();
            while (iterator.hasNext()) {
                Node part = iterator.nextNode();
                if (!part.getPrimaryNodeType().getName().equals(NT_PART)) continue;
                logger.debug((Object)part.getPrimaryNodeType().getName());
                String parentURI = part.getProperty(PARENT_URI).getString();
                String uri = part.getProperty(URI).getString();
                String name = part.getProperty(NAME).getString();
                String mimeType = part.getProperty(MIME_TYPE).getString();
                JCRDocumentPartLink documentAlternativeLink = new JCRDocumentPartLink(parentURI, uri, name, mimeType);
                list.add(documentAlternativeLink);
            }
        }
        catch (RepositoryException e) {
            logger.debug((Object)"getPartsFromNode failed");
        }
        return list;
    }

    public InputStream getData() throws InternalErrorException {
        return this.documentContent.getData();
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.documentContent.getLength();
    }

    public String getMimeType() {
        return this.documentContent.getMimeType();
    }

    public Map<String, DocumentMetadata> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getAnnotation() {
        return this.annotations;
    }

    public List<DocumentAlternativeLink> getAlternatives() {
        return this.alternatives;
    }

    public List<DocumentPartLink> getParts() {
        return this.parts;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.DOCUMENT;
    }

    public String getURI() {
        return this.oid;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        Node fileNode = JCRRepository.getGCubeRoot(node.getSession()).getNode(Text.escapeIllegalJcrChars((String)this.oid)).getNode("jcr:content");
        this.documentContent.save(fileNode);
    }
}

