/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRAnnotation
extends JCRWorkspaceFolderItem
implements Annotation {
    private static final String OID = "hl:oid";
    private static final String ANNOTATIONS = "hl:annotations";
    private static final String CONTENT = "jcr:content";
    private static final String NT_CONTENT = "nthl:annotationItemContet";
    private final String oid;

    public JCRAnnotation(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        Node contentNode = node.getNode(CONTENT);
        this.oid = contentNode.getProperty(OID).getString();
    }

    public JCRAnnotation(JCRWorkspace workspace, Node node, String name, String description, String oid, Map<String, String> data) throws RepositoryException {
        super(workspace, node, name, description);
        this.oid = oid;
        Node contentNode = node.addNode(CONTENT, NT_CONTENT);
        node.setProperty("hl:workspaceItemType", FolderItemType.ANNOTATION.toString());
        contentNode.setProperty(OID, oid);
        this.serializeAnnotations(contentNode, data);
    }

    private void serializeAnnotations(Node contentNode, Map<String, String> map) throws RepositoryException {
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            annotationsNode.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> deserializeAnnotations(Node contentNode) throws RepositoryException {
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        HashMap<String, String> map = new HashMap<String, String>();
        PropertyIterator iterator = annotationsNode.getProperties();
        Property p = iterator.nextProperty();
        while (iterator.hasNext()) {
            map.put(p.getName(), p.getValue().getString());
        }
        return map;
    }

    public String getURI() {
        return this.oid;
    }

    public Map<String, String> getData() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode(CONTENT);
            Map<String, String> map = this.deserializeAnnotations(contentNode);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.ANNOTATION;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }
}

