package org.gcube.portlets.user.homelibrary.jcr.data;

import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationDataArea;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataFolder;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.application.JCRApplicationDataArea;

public class JCRDataArea implements DataArea {

	private JCRRepository contentManager;
	private GCUBELog logger;
	private static final String DATA_FOLDER = "ApplicationData";
	
	
	public JCRDataArea(JCRRepository contentManager) {
		super();
		
		this.contentManager = contentManager;
		
		
	}

	@Override
	public ApplicationDataArea getApplicationDataArea(String applicationName)
			throws InternalErrorException {
			
		if (applicationName==null){
			logger.error("application name parameter null");
			throw new IllegalArgumentException("The applicationName can't be null");
		}
		
		return new JCRApplicationDataArea(applicationName, contentManager);
	}

	@Override
	public ApplicationDataArea getApplicationDataArea(Class<?> applicationClass)
			throws InternalErrorException {
		logger.info("getApplicationDataArea applicationClass: "+applicationClass);
		
		if (applicationClass == null){
			logger.error("application class parameter null");
			throw new IllegalArgumentException("The applicationClass can't be null");
		}
		
		String applicationName = applicationClass.getCanonicalName();
		logger.trace("Application name: "+applicationName);
		
		return getApplicationDataArea(applicationName);
	}

	@Override
	public List<String> listApplicationNames() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DataFolder getDataFolderRoot() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DataFolder getRelativeFolder(String relPath)
			throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

}
