/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;

public abstract class JCRWorkspaceFolderItem
extends JCRWorkspaceItem
implements FolderItem {
    protected static final String WORKFLOW_ID = "hl:workflowId";
    protected static final String WORKFLOW_STATUS = "hl:workflowStatus";
    protected static final String WORKFLOW_DATA = "hl:workflowData";
    protected static final String CONTENT = "jcr:content";
    protected static final String FOLDER_ITEM_TYPE = "hl:workspaceItemType";

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
    }

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, Node node, String name, String description) throws RepositoryException {
        super(workspace, node, name, description);
        node.setProperty(WORKFLOW_ID, "");
        node.setProperty(WORKFLOW_STATUS, "");
        node.setProperty(WORKFLOW_DATA, "");
    }

    @Override
    public void save(Node node) throws RepositoryException {
        super.save(node);
        Node contentNode = node.getNode(CONTENT);
        this.saveContent(contentNode);
    }

    public abstract void saveContent(Node var1) throws RepositoryException;

    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public abstract FolderItemType getFolderItemType();

    public abstract long getLength() throws InternalErrorException;

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return new ArrayList();
    }

    public void removeChild(WorkspaceItem child) {
    }

    public String getWorkflowId() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(WORKFLOW_ID).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setWorkflowId(String id) throws InternalErrorException {
        this.setWorkflowProperty(WORKFLOW_ID, id);
    }

    public String getWorkflowStatus() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(WORKFLOW_STATUS).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setWorkflowStatus(String status) throws InternalErrorException {
        this.setWorkflowProperty(WORKFLOW_STATUS, status);
    }

    public String getWorkflowData() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(WORKFLOW_DATA).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setWorkflowData(String data) throws InternalErrorException {
        this.setWorkflowProperty(WORKFLOW_DATA, data);
    }

    private final void setWorkflowProperty(String property, String value) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                session.getNodeByIdentifier(this.identifier).setProperty(property, value);
                session.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    @Override
    public Properties getProperties() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRProperties jCRProperties = new JCRProperties(node);
            return jCRProperties;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

