/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;

public abstract class JCRAbstractWorkspaceFolder
extends JCRWorkspaceItem
implements WorkspaceFolder {
    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
    }

    public JCRAbstractWorkspaceFolder(JCRWorkspace workspace, Node node, String name, String description) throws RepositoryException {
        super(workspace, node, name, description);
    }

    public JCRWorkspace getWorkspace() {
        return this.workspace;
    }

    public abstract WorkspaceItemType getType();

    public boolean exists(String name) throws InternalErrorException {
        try {
            return this.workspace.exists(name, this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem find(String name) throws InternalErrorException {
        try {
            return this.workspace.find(name, this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkspaceItem> getChildren() {
        ArrayList<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            try {
                Node folderNode = session.getNodeByIdentifier(this.identifier);
                NodeIterator iterator = folderNode.getNodes();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    String nodeType = node.getPrimaryNodeType().getName();
                    try {
                        if (nodeType.startsWith("rep:")) continue;
                        JCRWorkspaceItem item = this.workspace.getWorkspaceItem(node);
                        if (this.workspace.getScope() != null && item.getType() == WorkspaceItemType.FOLDER_ITEM && !item.getOwner().getScope().toString().equals(this.workspace.getScope().toString())) continue;
                        children.add(item);
                    }
                    catch (InternalErrorException e) {
                    }
                    catch (RepositoryException e) {}
                }
            }
            catch (RepositoryException e) {
                logger.error((Object)"No nodes retrieved", (Throwable)e);
            }
        }
        catch (InternalErrorException e) {
            logger.error((Object)"Session problem", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return children;
    }

    public WorkspaceFolder createFolder(String name, String description) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.createFolder(name, description, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalImage createExternalImageItem(String name, String description, String mimeType, InputStream imageData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalImage(name, description, mimeType, imageData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalFile createExternalFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalFile(name, description, mimeType, fileData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalPDFFile createExternalPDFFileItem(String name, String description, String mimeType, InputStream fileData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalPDFFile(name, description, mimeType, fileData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalUrl createExternalUrlItem(String name, String description, String url) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, url, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalUrl createExternalUrlItem(String name, String description, InputStream url) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createExternalUrl(name, description, url, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ReportTemplate createReportTemplateItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReportTemplate(name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Report createReportItem(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createReport(name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQueryItem(String name, String description, String query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Query createQueryItem(String name, String description, InputStream query, QueryType queryType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createQuery(name, description, query, queryType, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder createAquaMapsItem(String name, String description, String mapName, String mapType, String author, int numberOfSpecies, String boundingBox, float psoThreshold, int numberOfGeneratedImages, InputStream metadata, Map<String, InputStream> images) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        return this.workspace.createAquaMapsItem(name, description, mapName, mapType, author, numberOfSpecies, boundingBox, psoThreshold, numberOfGeneratedImages, metadata, images, this.getId());
    }

    public Annotation createAnnotationItem(String name, String description, String oid, Map<String, String> data) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        return null;
    }

    public Metadata createMetadataItem(String name, String description, String oid, String schema, String language, String metadata, String collectionName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createMetadata(name, description, oid, schema, language, metadata, collectionName, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Document createDocumentItem(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createDocument(name, description, oid, mimeType, documentData, metadata, annotations, collectionName, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ImageDocument createImageDocumentItem(String name, String description, String oid, String mimeType, InputStream imageData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createImageDocument(name, description, oid, mimeType, imageData, metadata, annotations, collectionName, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public PDFDocument createPDFDocumentItem(String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createPDFDocument(name, description, oid, mimeType, data, metadata, annotations, collectionName, this.getId());
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public UrlDocument createUrlDocumentItem(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createUrlDocument(name, description, oid, mimeType, documentData, metadata, annotations, collectionName, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public DocumentLink createDocumentLinkItem(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createDocumentLink(name, description, oid, metadata, annotations, collectionName, mimeType, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ImageDocumentLink createImageDocumentLinkItem(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createImageDocumentLink(name, description, oid, metadata, annotations, collectionName, mimeType, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public PDFDocumentLink createPDFDocumentLinkItem(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createPDFDocumentLink(name, description, oid, metadata, annotations, collectionName, mimeType, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createTimeSeries(name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createWorkflowReport(name, description, workflowId, workflowStatus, workflowData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkflowTemplate createWorkflowTemplate(String name, String description, String workflowId, String workflowStatus, String workflowData) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createWorkflowTemplate(name, description, workflowId, workflowStatus, workflowData, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public FolderBulkCreator getNewFolderBulkCreator() throws InternalErrorException {
        try {
            return this.workspace.getNewFolderBulkCreator(this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(child.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ExternalResourceLink createExternalResourceLink(String name, String description, String mimeType, String resourceId, String pluginName) throws InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        try {
            return this.workspace.createExternalResourceLink(name, description, mimeType, resourceId, pluginName, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public TabularDataLink createTabularDataLink(String name, String description, String tableId, String template, String provenance, String runtimeResourceName) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        try {
            return this.workspace.createTabularDataLink(name, description, tableId, template, provenance, runtimeResourceName, this.getId());
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

