/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.data;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.data.ApplicationsArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRApplicationsArea
implements ApplicationsArea {
    private String rootId;
    private JCRWorkspaceFolder applicationsArea;
    private JCRWorkspace worksapce;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRApplicationsArea(JCRWorkspace workspace) {
        this.worksapce = workspace;
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = JCRRepository.getApplicationsRoot(session);
            this.applicationsArea = new JCRWorkspaceFolder(workspace, node);
        }
        catch (InternalErrorException e) {
        }
        catch (RepositoryException repositoryException) {
        }
        finally {
            session.logout();
        }
    }

    private WorkspaceFolder getApplicationRoot(Session session, String applicationName) throws InternalErrorException {
        try {
            WorkspaceFolder folder = (WorkspaceFolder)this.applicationsArea.find(applicationName);
            if (folder == null) {
                folder = this.applicationsArea.createFolder(applicationName, applicationName);
            }
            WorkspaceFolder workspaceFolder = folder;
            return workspaceFolder;
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder getApplicationRoot(Class<?> applicationClass) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        return this.getApplicationRoot(session, applicationClass.getName());
    }

    public List<String> listApplicationNames() throws InternalErrorException {
        return null;
    }

    public WorkspaceFolder getApplicationUserRoot(Class<?> applicationClass) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        WorkspaceFolder applicationsRoot = this.getApplicationRoot(applicationClass);
        try {
            WorkspaceFolder userFolder = (WorkspaceFolder)applicationsRoot.find(this.worksapce.getOwner().getPortalLogin());
            if (userFolder == null) {
                userFolder = applicationsRoot.createFolder(applicationClass.getName(), applicationClass.getName());
            }
            WorkspaceFolder workspaceFolder = userFolder;
            return workspaceFolder;
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

