/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;

public class JCRAccountingEntryRead
implements AccountingEntryRead {
    private static final String DATE = "hl:date";
    private final String user;
    private final Calendar date;

    public JCRAccountingEntryRead(Node node) throws RepositoryException {
        this.user = node.getName();
        this.date = node.getProperty(DATE).getDate();
    }

    public JCRAccountingEntryRead(String user, Calendar date) {
        this.user = user;
        this.date = date;
    }

    public String getUser() {
        return this.user;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void save(Node entryNode) throws RepositoryException {
        entryNode.setProperty(DATE, this.date);
    }

    public AccountingEntryType getEntryType() {
        return AccountingEntryType.READ;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return String.format("[ user:%s, date:%s ]", this.user, sdf.format(this.date.getTime()));
    }
}

