package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import ij.ImagePlus;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRImage extends JCRFile implements Image {

	private static final String IMAGE_WIDTH 		= "hl:width";
	private static final String IMAGE_HEIGHT 		= "hl:height";
	private static final String THUMBNAIL_DATA 		= "hl:thumbnailData";
	private static final String THUMBNAIL_WIDTH 	= "hl:thumbnailWidth";
	private static final String THUMBNAIL_HEIGHT 	= "hl:thumbnailHeight";
	

	
	
	public JCRImage(Node node) throws RepositoryException  {
		super(node);

		
	}
	
	public JCRImage(Node node, InputStream data)throws RepositoryException, IOException, RemoteBackendException {
		super(node, new BufferedInputStream(data));
		

		String remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
		InputStream dataImage = GCUBEStorage.getRemoteFile(remotePath);
		
		
		ImagePlus imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
		int width = imagePlus.getWidth();
		int height = imagePlus.getHeight();
			
		int[] thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
		InputStream thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus,
				thumbnailSize);
		
		Binary binary = node.getSession().getValueFactory().createBinary(thumbnailStream);
		
		node.setProperty(IMAGE_WIDTH, width);
		node.setProperty(IMAGE_HEIGHT, height);
		node.setProperty(THUMBNAIL_WIDTH,  thumbnailSize[0]);
		node.setProperty(THUMBNAIL_HEIGHT, thumbnailSize[1]);
		node.setProperty(THUMBNAIL_DATA,binary);
			
		thumbnailStream.close();
		imagePlus.close();
		dataImage.close();
	}
	

	@Override
	public int getWidth() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(IMAGE_WIDTH).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
		
	}

	@Override
	public int getHeight() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(IMAGE_HEIGHT).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	@Override
	public InputStream getThumbnail() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(THUMBNAIL_DATA).getBinary().getStream();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}	
	}

	@Override
	public int getThumbnailWidth() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(THUMBNAIL_WIDTH).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	@Override
	public int getThumbnailHeight() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(THUMBNAIL_HEIGHT).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	@Override
	public long getThumbnailLength() throws InternalErrorException {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(THUMBNAIL_DATA).getBinary().getSize();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

}
