/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

public class GCUBEStorage {
    private static GCUBEClientLog logger = new GCUBEClientLog(GCUBEStorage.class, new Properties[0]);
    private static IClient storage;
    private static String scope;

    public static String putStream(InputStream is, String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace((Object)("GCUBE Storage RFile path : " + remotePath));
        storage.put(true).LFile(is).RFile(remotePath);
        try {
            is.close();
            logger.trace((Object)"GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error((Object)"GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return storage.getUrl().RFile(remotePath);
    }

    public static long getRemoteFileSize(String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace((Object)("GCUBE Storage RFile path : " + remotePath));
        long size = storage.getSize().RFile(remotePath);
        return size;
    }

    public static void removeRemoteFile(String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace((Object)("GCUBE Storage RFile path : " + remotePath));
        storage.remove().RFile(remotePath);
    }

    public static InputStream getRemoteFile(String remotePath) {
        ScopeProvider.instance.set(scope);
        return storage.get().RFileAsInputStream(remotePath);
    }

    static {
        try {
            GHNContext ctx = GHNContext.getContext();
            String rootVOName = (String)ctx.getProperty("infrastructure", new boolean[]{true});
            scope = "/" + rootVOName;
            ScopeProvider.instance.set(scope);
            storage = new StorageClient("org.gcube.portlets.user", "home-library", "home-library", AccessType.SHARED).getClient();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.fatal((Object)"GCUBE Storage initialization failed");
        }
    }
}

