/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.home.JCRHome;
import org.gcube.portlets.user.homelibrary.util.accesslog.AccessLogUtil;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHomeManager
implements HomeManager {
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private Map<String, JCRHome> userHomesLogged = new LinkedHashMap<String, JCRHome>();
    private HomeManagerFactory factory;
    private final File persistenceFoolder;
    private static Logger logger = LoggerFactory.getLogger(JCRHomeManager.class);

    public JCRHomeManager(HomeManagerFactory factory, File persistenceFolder) {
        this.persistenceFoolder = persistenceFolder;
        this.factory = factory;
        this.createUsers();
    }

    private void createUsers() {
        try {
            GHNContext ctx = GHNContext.getContext();
            String rootOrgName = (String)ctx.getProperty("infrastructure", new boolean[]{true});
            LiferayGroupManager gm = new LiferayGroupManager();
            LiferayUserManager um = new LiferayUserManager();
            logger.debug("Start import portal users");
            for (UserModel model : um.listUsersByGroup(gm.getGroupId(rootOrgName))) {
                this.createUser(model.getScreenName());
                logger.debug("User " + model.getScreenName() + " imported");
            }
        }
        catch (Throwable e) {
            logger.error("Users not retrieved", e);
        }
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.info("getUser portalLogin: " + portalLogin);
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace("existUser portalLogin: " + portalLogin);
        if (portalLogin == null) {
            logger.error("portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            logger.info("User " + portalLogin + " not found, creating a new one.");
            user = new JCRUser(UUID.randomUUID().toString(), portalLogin, null);
            logger.info("User created: " + user);
            this.users.put(portalLogin, user);
        }
        return user;
    }

    public Home getHome(User user, GCUBEScope scope) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.info("getHome user: " + user);
        if (this.userHomesLogged.containsKey(user.getPortalLogin())) {
            logger.debug(" User is already logged");
            JCRHome home2 = this.userHomesLogged.get(user.getPortalLogin());
            if (scope != null) {
                home2.setScope(scope);
            }
            return home2;
        }
        try {
            ((JCRUser)user).setScope(scope);
            home = new JCRHome(this, (JCRUser)user, this.persistenceFoolder);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.userHomesLogged.put(user.getPortalLogin(), home);
        logger.trace("User loaded.");
        if (user.getScope() != null) {
            AccessLogUtil.logWorkspaceCreated((User)user);
        }
        return home;
    }

    public Home getHome(String portalLogin, GCUBEScope scope) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.info("getHome portalLogin: " + portalLogin);
        User user = this.getUser(portalLogin);
        return this.getHome(user, scope);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        this.userHomesLogged.remove(user.getPortalLogin());
    }
}

