package org.gcube.portlets.user.homelibrary.jcr.data;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.portlets.user.homelibrary.home.data.ApplicationsArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRApplicationsArea implements ApplicationsArea {

	private static final String SHARE = "share";
	private static final String USERS = "users";
	
	private JCRWorkspaceFolder applicationsArea;
	private JCRWorkspace worksapce;
	
	public JCRApplicationsArea(JCRWorkspace workspace) {
		this.worksapce = workspace;
		
		Session session = null;
		try {
			
			session =  JCRRepository.getSession();
			Node node =  JCRRepository.getApplicationsRoot(session);
			applicationsArea = new JCRWorkspaceFolder(workspace, node);
			
		} catch (InternalErrorException e) {
			
		} catch (RepositoryException e) {
			
		} finally {
			session.logout();
		}
	}
	
	private WorkspaceFolder getApplicationRoot(Session session, String applicationName) throws InternalErrorException {
		
		try {
			
			WorkspaceFolder folder = (WorkspaceFolder)applicationsArea.find(applicationName);
			if (folder == null) {
				folder = applicationsArea.createFolder(applicationName, applicationName);
				folder.createFolder(USERS, "");
				folder.createFolder(SHARE, "");
			}
			
			return folder;
		} catch (InsufficientPrivilegesException e) {
			throw new InternalErrorException(e);
		} catch (ItemAlreadyExistException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	
	@Override
	public WorkspaceFolder getApplicationRoot(String applicationName)
			throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		return getApplicationRoot(session, applicationName);
		
	}
		
	@Override
	public List<String> listApplicationNames() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public WorkspaceFolder getApplicationUserRoot(String applicationName)
			throws InternalErrorException {
		
		Session session = JCRRepository.getSession();
		WorkspaceFolder applicationsRoot = getApplicationRoot(applicationName);
		try {
			WorkspaceFolder usersFolder = (WorkspaceFolder)applicationsRoot.find(USERS);
			WorkspaceFolder userFolder = (WorkspaceFolder)usersFolder.find(
					worksapce.getOwner().getPortalLogin());
			if (userFolder == null)
				userFolder = usersFolder.createFolder(worksapce.getOwner().getPortalLogin(),
						applicationName);
			return userFolder;
		} catch (InsufficientPrivilegesException e) {
			throw new InternalErrorException(e);
		} catch (ItemAlreadyExistException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}

	@Override
	public WorkspaceFolder getApplicationShareRoot(String applicationName)
			throws InternalErrorException {
		Session session = JCRRepository.getSession();
		WorkspaceFolder applicationsRoot = getApplicationRoot(applicationName);
		try {
			WorkspaceFolder shareFolder = (WorkspaceFolder)applicationsRoot.find(SHARE);
			return shareFolder;
		} finally {
			session.logout();
		}
	}
	
	
}
