/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
    private static IClient storage;
    private static String scope;

    static {
        try {
            GHNContext ctx = GHNContext.getContext();
            String rootVOName = (String)ctx.getProperty("infrastructure", new boolean[]{true});
            scope = "/" + rootVOName;
            ScopeProvider.instance.set(scope);
            storage = new StorageClient("org.gcube.portlets.user", "home-library", "home-library", AccessType.SHARED).getClient();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.error("GCUBE Storage initialization failed", (Throwable)e);
        }
    }

    public static String putStream(InputStream is, String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace("GCUBE Storage RFile path : " + remotePath);
        storage.put(true).LFile(is).RFile(remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return storage.getUrl().RFile(remotePath);
    }

    public static long getRemoteFileSize(String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace("GCUBE Storage RFile path : " + remotePath);
        long size = storage.getSize().RFile(remotePath);
        return size;
    }

    public static void removeRemoteFile(String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace("GCUBE Storage RFile path : " + remotePath);
        storage.remove().RFile(remotePath);
    }

    public static void removeRemoteFolder(String remotePath) throws RemoteBackendException {
        ScopeProvider.instance.set(scope);
        logger.trace("GCUBE Storage RDir path : " + remotePath);
        storage.removeDir().RDir(remotePath);
    }

    public static InputStream getRemoteFile(String remotePath) {
        ScopeProvider.instance.set(scope);
        return storage.get().RFileAsInputStream(remotePath);
    }

    public static String getPublicLink(String remotePath) {
        String publicUrl = storage.getUrl().RFile(remotePath);
        return publicUrl;
    }

    public static void moveRemoteFolder(String oldPath, String newPath) {
        storage.moveDir().from(oldPath).to(newPath);
    }

    public static void moveRemoteFile(String oldPath, String newPath) {
        storage.moveFile().from(oldPath).to(newPath);
    }

    public static void createHardLink(String srcPath, String destPath) {
        try {
            storage.linkFile().from(srcPath).to(destPath);
            logger.trace("GCUBE Storage linkFile path : " + destPath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage error creating a linkFile", (Throwable)e);
        }
    }
}

