/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.util.Text;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.File;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFile
implements File {
    private static Logger logger = LoggerFactory.getLogger(JCRFile.class);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    protected String nodeId;
    private String mimeType;
    private long size;

    public JCRFile(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
        try {
            this.mimeType = node.getProperty(MIME_TYPE).getString();
        }
        catch (Exception e) {
            this.mimeType = "application/octet-stream";
        }
        this.size = node.getProperty(SIZE).getLong();
    }

    public JCRFile(Node node, String mimeType, InputStream data) throws RepositoryException, RemoteBackendException {
        String remotePath = Text.getRelativeParent((String)node.getPath(), (int)1);
        String url = GCUBEStorage.putStream(data, remotePath);
        logger.trace("GCUBEStorage URL : " + url);
        ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
        Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
        node.setProperty(DATA, binary);
        this.setProperties(node, remotePath, mimeType);
        node.setProperty(REMOTE_STORAGE_PATH, remotePath);
        this.mimeType = mimeType;
    }

    private void setProperties(Node node, String remotePath, String mimeType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.size = GCUBEStorage.getRemoteFileSize(remotePath);
        node.setProperty(SIZE, this.size);
        node.setProperty(MIME_TYPE, mimeType);
    }

    public void save(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
    }

    public JCRFile(Node node, InputStream data) throws RepositoryException, RemoteBackendException {
        this(node, MimeTypeUtil.getMimeType((InputStream)data), data);
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getName();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("Old retrieve content method");
            }
            if (remotePath != null) {
                logger.trace("Content retrieved from remote storage...");
                InputStream inputStream = GCUBEStorage.getRemoteFile(remotePath);
                return inputStream;
            }
            Binary data = node.getProperty(DATA).getBinary();
            try {
                logger.trace("Content moved to remote storage");
                remotePath = node.getPath();
                String url = GCUBEStorage.putStream(data.getStream(), remotePath);
                logger.trace("New gcube storage url : " + url);
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                node.setProperty(DATA, binary);
                node.setProperty(REMOTE_STORAGE_PATH, remotePath);
                session.save();
            }
            catch (Exception e) {
                logger.error("The item doesn't contain hl:remotePath property");
            }
            InputStream inputStream = data.getStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public long getLength() throws InternalErrorException {
        return this.size;
    }

    public String getPublicLink() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("No public link for file: " + node.getPath());
            }
            String string = GCUBEStorage.getPublicLink(remotePath);
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void getHardLink(String destPath) throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.nodeId);
                try {
                    remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
                }
                catch (PathNotFoundException e) {
                    logger.trace("No public link for file: " + node.getPath());
                }
                GCUBEStorage.createHardLink(remotePath, destPath);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void updateInfo() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.nodeId);
                try {
                    remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
                    BufferedInputStream data = new BufferedInputStream(GCUBEStorage.getRemoteFile(remotePath));
                    String mimeType = MimeTypeUtil.getMimeType((InputStream)data);
                    this.setProperties(node, remotePath, mimeType);
                    session.save();
                }
                catch (PathNotFoundException e) {
                    logger.trace("No public link for file: " + node.getPath());
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }
}

