/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRDocumentMetadata;

public class JCRDocumentLink
extends JCRWorkspaceFolderItem
implements DocumentLink {
    private static final String METADATA = "hl:metadata";
    private static final String ANNOTATIONS = "hl:annotations";
    private static final String COLLECTION_NAME = "hl:collectionName";
    private static final String OID = "hl:oid";
    private static final String NT_CONTENT = "nthl:documentLinkItemContent";
    private final String oid;
    private final Map<String, DocumentMetadata> metadata;
    private final Map<String, String> annotations;
    private final String collectionName;

    public JCRDocumentLink(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.collectionName = contentNode.getProperty(COLLECTION_NAME).getString();
        this.oid = contentNode.getProperty(OID).getString();
        this.metadata = this.deserializeMetadata(contentNode);
        this.annotations = this.deserializeAnnotations(contentNode);
    }

    public JCRDocumentLink(JCRWorkspace workspace, Node node, String name, String description, String oid, String mimeType, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws RepositoryException {
        super(workspace, node, name, description);
        Validate.notNull((Object)oid, (String)"Oid must be not null");
        Validate.notNull((Object)mimeType, (String)"MimeType must be not null");
        Validate.notNull(metadata, (String)"Metadata must be not null");
        Validate.notNull(annotations, (String)"Annotations must be not null");
        Validate.notNull((Object)collectionName, (String)"CollectionName must be not null");
        node.setProperty("hl:workspaceItemType", FolderItemType.DOCUMENT_LINK.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        this.oid = oid;
        this.collectionName = collectionName;
        this.metadata = this.serializeMetadata(contentNode, metadata);
        this.annotations = this.serializeAnnotations(contentNode, annotations);
        contentNode.setProperty(OID, oid);
        contentNode.setProperty(COLLECTION_NAME, collectionName);
    }

    private Map<String, DocumentMetadata> serializeMetadata(Node contentNode, Map<String, String> metadata) throws RepositoryException {
        Node metadataNode = contentNode.getNode(METADATA);
        HashMap<String, DocumentMetadata> map = new HashMap<String, DocumentMetadata>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            metadataNode.setProperty(entry.getKey(), entry.getValue());
            map.put(entry.getKey(), new JCRDocumentMetadata(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private Map<String, DocumentMetadata> deserializeMetadata(Node contentNode) throws RepositoryException {
        Node metadataNode = contentNode.getNode(METADATA);
        HashMap<String, DocumentMetadata> map = new HashMap<String, DocumentMetadata>();
        PropertyIterator iterator = metadataNode.getProperties();
        Property property = iterator.nextProperty();
        while (iterator.hasNext()) {
            if (!property.getName().startsWith("jcr:")) {
                JCRDocumentMetadata metadata = new JCRDocumentMetadata(property.getName(), property.getValue().getString());
                map.put(property.getName(), metadata);
            }
            property = iterator.nextProperty();
        }
        return map;
    }

    private Map<String, String> serializeAnnotations(Node contentNode, Map<String, String> annotations) throws RepositoryException {
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        for (Map.Entry<String, String> entry : annotations.entrySet()) {
            annotationsNode.setProperty(entry.getKey(), entry.getValue());
        }
        return annotations;
    }

    private Map<String, String> deserializeAnnotations(Node contentNode) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        Node annotationsNode = contentNode.getNode(ANNOTATIONS);
        PropertyIterator iterator = annotationsNode.getProperties();
        Property property = iterator.nextProperty();
        while (iterator.hasNext()) {
            if (!property.getName().startsWith("jcr:")) {
                map.put(property.getName(), property.getValue().getString());
            }
            property = iterator.nextProperty();
        }
        return map;
    }

    public String getOID() {
        return this.oid;
    }

    public Map<String, DocumentMetadata> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getAnnotation() {
        return this.annotations;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.DOCUMENT_LINK;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }
}

