package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.IOException;
import java.io.InputStream;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRExternalImage extends JCRExternalFile implements
		ExternalImage {
	
	public JCRExternalImage(JCRWorkspace workspace, Node node) throws RepositoryException  {
		super(workspace, node,ContentType.IMAGE);
		
	}
	
	public JCRExternalImage(JCRWorkspace workspace, Node node, String name, String description,
			String mimeType, InputStream data) throws RepositoryException, IOException, RemoteBackendException   {
		super(workspace,node,name,description,mimeType,ContentType.IMAGE,data);
	}

	@Override
	public int getWidth() {
		return ((JCRImage)content).getWidth();
	}

	@Override
	public int getHeight() {
		return ((JCRImage)content).getHeight();
	}

	@Override
	public InputStream getThumbnail() throws InternalErrorException {
		return ((JCRImage)content).getThumbnail();
	}

	@Override
	public int getThumbnailWidth() {
		return ((JCRImage)content).getThumbnailWidth();
	}

	@Override
	public int getThumbnailHeight() {
		return ((JCRImage)content).getThumbnailHeight();
	}

	@Override
	public long getThumbnailLength() throws InternalErrorException {
		return ((JCRImage)content).getThumbnailLength();
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_IMAGE;
	}


	@Override
	public void updateInfo() throws InternalErrorException {
		super.updateInfo();
	}
	

}
