package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.ExternalResourceLinkPlugin;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourcePluginNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.jcr.JCRExternalResourcePluginManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRExternalResourceLink extends JCRWorkspaceFolderItem implements ExternalResourceLink {

	private static final String NT_CONTENT 		= "nthl:externalResourceLinkContent";
	
	private static final String SIZE			= "hl:size";
	private static final String MIME_TYPE 		= "hl:mimeType";
	private static final String RESOURCE_ID 	= "hl:resourceId";
	private static final String PLUGIN 			= "hl:servicePlugin"; 
	
	private String mimeType;
	private String resourceId;
	private String plugin;
	private long size;
	
	public JCRExternalResourceLink(JCRWorkspace workspace, Node node)
			 throws RepositoryException {
		super(workspace, node);
		
		Node contentNode = node.getNode(CONTENT);
		try {
			this.mimeType = contentNode.getProperty(MIME_TYPE).getString();
		} catch (PathNotFoundException e) {
			this.mimeType = null;
		}
		this.resourceId = contentNode.getProperty(RESOURCE_ID).getString();
		this.plugin = contentNode.getProperty(PLUGIN).getString();
		this.size = contentNode.getProperty(SIZE).getLong(); 
		 
	}

	public JCRExternalResourceLink(JCRWorkspace workspace, Node node, String name, String mimeType, 
			String description, String resourceId, String plugin) throws RepositoryException, InternalErrorException {
		super(workspace, node, name, description);
		
		this.mimeType = mimeType;
		this.resourceId = resourceId;
		this.plugin = plugin;
		
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_RESOURCE_LINK.toString());
		Node contentNode = node.addNode(CONTENT, NT_CONTENT);
		
		if (mimeType != null)
			contentNode.setProperty(MIME_TYPE, mimeType);
		
		contentNode.setProperty(RESOURCE_ID, resourceId);
		contentNode.setProperty(PLUGIN, plugin);
		
		try {
			ExternalResourceLinkPlugin resourcePlugin = JCRExternalResourcePluginManager.getPlugin(this.plugin);
			contentNode.setProperty(SIZE, resourcePlugin.getSize(this));
		} catch (ExternalResourceBrokenLinkException e) {
			logger.error("Error ",e);
			throw new InternalErrorException(e);
		} catch (ExternalResourcePluginNotFoundException e) {
			logger.error("Error ",e);
			throw new InternalErrorException(e);
		} 
	}
	
	@Override
	public String getMimeType() {
		return mimeType;
	}

	@Override
	public InputStream getData() throws InternalErrorException,
	ExternalResourceBrokenLinkException, ExternalResourcePluginNotFoundException {
		

		ExternalResourceLinkPlugin plugin =
				JCRExternalResourcePluginManager.getPlugin(this.plugin);
		return plugin.getContent(this);
			
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		return;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_RESOURCE_LINK;
	}


	@Override
	public String getResourceId() {
		return this.resourceId;
	}

	@Override
	public String getExternalResourcePlugin() {
		return plugin;
	}

	@Override
	public long getLength() throws InternalErrorException {
		return size;
	}

}
