/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRFolderBulkCreator;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFolderBulkCreatorManager
implements FolderBulkCreatorManager {
    private Logger logger;
    private final JCRWorkspace workspace;
    protected Map<String, Thread> threads = new LinkedHashMap<String, Thread>();

    public JCRFolderBulkCreatorManager(JCRWorkspace workspace) {
        this.logger = LoggerFactory.getLogger(JCRFolderBulkCreatorManager.class);
        this.workspace = workspace;
    }

    public FolderBulkCreator getFolderBulk(JCRWorkspaceFolder destinationFolder) throws InternalErrorException {
        String name = UUID.randomUUID().toString();
        return new JCRFolderBulkCreator(name, destinationFolder, this);
    }

    public void removeThread(String id) throws InternalErrorException {
        this.threads.remove(id);
    }

    public void addFolderBulkCreator(FolderBulkCreator folderBulk, Thread th) throws InternalErrorException {
        this.threads.put(folderBulk.getId(), th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FolderBulkCreator> getActiveFolderBulkCreators() {
        LinkedList<FolderBulkCreator> list = new LinkedList<FolderBulkCreator>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node rootCreator = this.workspace.getRepository().getRootFolderBulkCreators(session);
            NodeIterator iterator = rootCreator.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                list.add(new JCRFolderBulkCreator(this.workspace, node, this));
            }
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return list;
    }

    public FolderBulkCreator getActiveFolderBulkCreator(String id) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node rootCreator = this.workspace.getRepository().getRootFolderBulkCreators(session);
            JCRFolderBulkCreator jCRFolderBulkCreator = new JCRFolderBulkCreator(this.workspace, rootCreator.getNode(id), this);
            return jCRFolderBulkCreator;
        }
        catch (RepositoryException e) {
            this.logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void waitFolderBulkCreator(String id) throws InterruptedException {
        Thread th = this.threads.get(id);
        if (th != null) {
            th.join();
        }
    }
}

