/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRQuery
extends JCRWorkspaceFolderItem
implements Query {
    private static final String NT_CONTENT = "nthl:queryItemContent";
    private static final String QUERY = "hl:query";
    private static final String QUERY_TYPE = "hl:queryType";

    public JCRQuery(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
    }

    public JCRQuery(JCRWorkspace workspace, Node node, String name, String description, String query, QueryType queryType) throws RepositoryException {
        super(workspace, node, name, description);
        Validate.notNull((Object)query, (String)"Query must be not null");
        Validate.notNull((Object)queryType, (String)"Query Type must be not null");
        node.setProperty("hl:workspaceItemType", FolderItemType.QUERY.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty(QUERY, query);
        contentNode.setProperty(QUERY_TYPE, queryType.toString());
    }

    @Override
    public long getLength() throws InternalErrorException {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            long l = contentNode.getProperty(QUERY).getString().length();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public String getQuery() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            String string = contentNode.getProperty(QUERY).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public QueryType getQueryType() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            QueryType queryType = QueryType.valueOf((String)contentNode.getProperty(QUERY_TYPE).getString());
            return queryType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.QUERY;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

