/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.data.fs;

import java.io.File;
import java.io.IOException;
import java.util.Date;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;

/**
 * This class represent a file in the data home.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public interface DataFile extends DataAreaItem{
	
	/**
	 * @return the data file creation time.
	 */
	Date getCreationTime();
	
	/**
	 * @return the data file modification time.
	 */
	Date getLastModifiedTime();
	
	/**
	 * Export this file in to a destination folder in the file system.
	 * @param destFolder the destination folder.
	 * @throws IOException if an error occurs.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	void export(File destFolder) throws IOException, InternalErrorException;

}
