/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

public class FileSystemNameUtil {
    public static final char[] FILE_NAME_ILLEGAL_CHARACTERS = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\n', '\r', '\t', '\u0000', '\f', '`'};
    public static final char DEFAULT_REPLACE_CHAR = '_';
    public static final String[] INVALID_FILE_NAME = new String[]{"..", "."};
    public static final String[] WINDOWS_INVALID_FILE_NAME = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static final String REPLACE_NAME = "no-name";

    public static String cleanFileName(String name) {
        String cleanedName = FileSystemNameUtil.removeInvalidChars(name);
        cleanedName = FileSystemNameUtil.replaceInvalidName(cleanedName);
        return cleanedName;
    }

    protected static String removeInvalidChars(String name) {
        for (char invalidChar : FILE_NAME_ILLEGAL_CHARACTERS) {
            name = name.replace(invalidChar, '_');
        }
        return name;
    }

    protected static String replaceInvalidName(String name) {
        for (String invalidName : INVALID_FILE_NAME) {
            if (!name.equals(invalidName)) continue;
            return REPLACE_NAME;
        }
        for (String invalidName : WINDOWS_INVALID_FILE_NAME) {
            if (!name.equals(invalidName)) continue;
            return REPLACE_NAME;
        }
        return name;
    }
}

